<?php

class Script
{
    /**
     * 重置缓存
     */
    public function resetCache(){
        //更新数据库字段
        $category=runtimePath("cache/category");
        $module=runtimePath("cache/module");
        $setting=runtimePath("cache/setting");
        $fields=runtimePath("cache/fields");

        if(is_dir($category)){
            dirDelete($category);
        }
        if(is_dir($module)){
            dirDelete($module);
        }
        if(is_dir($setting)){
            dirDelete($setting);
        }
        if(is_dir($fields)){
            dirDelete($fields);
        }
        return true;
    }

    /**
     * 重置插件缓存
     */
    public function resetPluginCache(){
        //更新数据库字段
        $plugin=runtimePath("cache/plugin");
        if(is_dir($plugin)){
            dirDelete($plugin);
        }
        return true;
    }

    /**
     * 更新-随机数
     */
    public function upRandom(){
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'op' => 'random',
            'pid' => '4',
        );
        $setting=new \app\logic\api\L_setting($paramsObj);
        $checkResult=$setting->store($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }
        return true;
    }

    /**
     * 更新路由信息
     */
    public function upAdminFunc(){
        //去除前缀
        $pre=app("cmsTable")->getPre();
        $sql="UPDATE {$pre}member_admin_func SET route = REPLACE(route, 'admin/', '') where `plugins` =''";
        $sql2="UPDATE {$pre}member_admin_func SET route = REPLACE(route, '/category?', 'category?') where `plugins` ='' and `module`='admin/Category'";
        Db()->execute($sql);
        Db()->execute($sql2);
        return true;
    }

    /**
     * 安装自定义字段表
     */
    public function createFields(){
        //去除前缀
        $pre=app("cmsTable")->getPre();
        $sql="
        CREATE TABLE IF NOT EXISTS `{$pre}fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `table_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '表名',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '字段',
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `note` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '提示信息',
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '字段属性',
  `length` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '字段长度',
  `html` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '表单类型',
  `default_value` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '默认值',
  `option_value` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '选项卡值',
  `width` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '[图片上传]宽度',
  `height` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '[图片上传]高度',
  `input_limit` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '输入限制',
  `addition` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '附加内容',
  `backend_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '直接显示',
  `use_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '前台显示',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `tablename` (`table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自定义字段'
        ";
        $query=Db()->execute($sql);
        if($query===false){
            return false;
        }
        return true;
    }

    /**
     * 补充-文章-字段设置-菜单
     */
    public function addModuleFieldMenu(){
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "isLink"=>"0",
            "field"=>"id,name",
            "module"=>"article",
        );
        $checkResult=app("S_Admin_module")->allData($paramsObj);
        if($checkResult["error_no"]==0){
            $modulesResult=$checkResult["result"];
            if($modulesResult){
                foreach($modulesResult as $module){
                    //检查菜单
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'pid' => 1,
                        'name' => $module["name"]."管理",
                        'field' => "id",
                    );
                    $checkResult=app("S_Admin_adminMenu")->infoByUnique($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $menuResult=$checkResult["result"];
                        $nodeData=array();
                        $nodeData[]=array (
                            'menuId' => $menuResult["id"],
                            'routhAction' => 1,
                            'route' => 'fields?moduleId='.$module["id"],
                            'module' => 'app/admin/controller/Fields',
                            'moduleName' => '',
                            'action' => 'index',
                            'actionName' => '字段设置',
                            'other' => '',
                            'isShow' => 1,
                            'isEnable' => 1,
                            'sort' => 4,
                            'description' => '',
                            'plugins' => '',
                        );
                        //写入权限节点数据
                        if($menuResult && $nodeData){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'menuId' => $menuResult["id"],
                                'plugins' => "",
                                'data' => $nodeData,
                            );
                            $checkResult=app("S_Admin_adminFunc")->record($paramsObj);
                            if ($checkResult["error_no"]) {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    /**
     * 补充-文章-更新数据-菜单
     */
    public function addModuleUpdateMenu(){
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "isLink"=>"0",
            "field"=>"id,name",
            "module"=>"article",
        );
        $checkResult=app("S_Admin_module")->allData($paramsObj);
        if($checkResult["error_no"]==0){
            $modulesResult=$checkResult["result"];
            if($modulesResult){
                foreach($modulesResult as $module){
                    //检查菜单
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'pid' => 1,
                        'name' => $module["name"]."管理",
                        'field' => "id",
                    );
                    $checkResult=app("S_Admin_adminMenu")->infoByUnique($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $menuResult=$checkResult["result"];
                        $nodeData=array();
                        $nodeData[]=array (
                            'menuId' => $menuResult["id"],
                            'routhAction' => 1,
                            'route' => 'cache?moduleId='.$module["id"],
                            'module' => 'app/admin/controller/Cache',
                            'moduleName' => '',
                            'action' => 'index',
                            'actionName' => '更新数据',
                            'other' => '',
                            'isShow' => 1,
                            'isEnable' => 1,
                            'sort' => 4,
                            'description' => '',
                            'plugins' => '',
                        );
                        //写入权限节点数据
                        if($menuResult && $nodeData){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'menuId' => $menuResult["id"],
                                'plugins' => "",
                                'data' => $nodeData,
                            );
                            $checkResult=app("S_Admin_adminFunc")->record($paramsObj);
                            if ($checkResult["error_no"]) {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    /**
     * 补充-缓存设置-菜单
     */
    public function addMenu($filename){
        $menuFile=LTCMS_ROOT."/version/menu/{$filename}.php";
        if(is_file($menuFile)){
            //写入后台菜单
            $menuData=include_once $menuFile;
            if($menuData){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "plugins"=>"",
                    "data"=>$menuData,
                );
                $checkResult=app("L_Admin_adminMenu")->recordMenu($paramsObj);
                if($checkResult["error_no"]){
                    return false;
                }
            }
        }
        return true;
    }

    /**
     * 文章内容-去除反斜线
     */
    public function removeBackslashes(){
        $ok3=false;
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            'column' => 'articleContent',
            'type' => 'all_article_data',
        );
        $checkResult=app("L_Admin_article")->removeBackslashes($paramsObj); //文章内容-去除反斜线
        if ($checkResult["error_no"] == 0) {
            $ok3=true;
        }
        return $ok3;
    }

    /**
     * 添加-分类菜单
     */
    public function addCategoryField(){
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'table_name' => 'category',
            'name' => 'template_list',
            'type' => 'varchar',
            'default_value' => '',
            'length' => '255',
        );
        $checkResult=app("L_table")->addField($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }

        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'table_name' => 'category',
            'name' => 'template_content',
            'type' => 'varchar',
            'default_value' => '',
            'length' => '255',
        );
        $checkResult=app("L_table")->addField($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }
        return true;
    }

    /**
     * 添加-菜单置顶字段
     */
    public function addAdminMenuFieldIsTop(){
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'table_name' => 'member_admin_menu',
            'name' => 'isTop',
            'type' => 'int',
            'default_value' => '0',
            'length' => '10',
        );
        $checkResult=app("L_table")->addField($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }

        //更新对应的排序数据
        $top=array(
            array(
                "name"=>"系统设置",
                "pid"=>"1",
            ),
            array(
                "name"=>"版本更新",
                "pid"=>"1",
            ),
            array(
                "name"=>"软件商店",
                "pid"=>"1",
            ),
            array(
                "name"=>"后台权限",
                "pid"=>"1",
            ),
            array(
                "name"=>"拓展管理",
                "pid"=>"1",
            ),
        );
        foreach($top as $val){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => $val["pid"],
                'name' => $val["name"],
            );
            app("S_Admin_adminMenu")->topOperation($paramsObj);
        }
        return true;
    }

    /**
     * 安装操作日志表
     */
    public function createTableLogOperation(){
        //去除前缀
        $pre=app("cmsTable")->getPre();
        $sql="
        CREATE TABLE IF NOT EXISTS `{$pre}log_operation` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `author` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '操作人员',
  `action` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '动作',
  `content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '内容',
  `create_time` bigint(20) NOT NULL DEFAULT '0' COMMENT '时间',
  `ip_address` varchar(20) NOT NULL DEFAULT '' COMMENT 'ip地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='日志操作记录'
        ";
        $query=Db()->execute($sql);
        if($query===false){
            return false;
        }
        return true;
    }

    /**
     * 添加默认友链
     */
    public function addFriend(){
        $linkname="龙腾CMS";
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'linkName' => $linkname,
            'verify' => '0',
        );
        $checkResult=app("S_Admin_friendLink")->infoByLinkName($paramsObj);
        if($checkResult["error_no"]=="0"){
            $result=$checkResult["result"];
            if(!$result){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'status' => '1',
                    'linkName' => $linkname,
                    'linkUrl' => 'https://www.ltcms.com',
                    'className' => '#000000',
                );
                $checkResult=app("S_Admin_friendLink")->store($paramsObj);
                if($checkResult["error_no"]){
                    return false;
                }
            }
        }else{
            return false;
        }
        return true;
    }

    /**
     * 更新登录信息
     */
    public function updateLoginData(){
        //获取登录数据
        $loginUserData=\Ltcms_domain_auth_check_key::loginData();
        $guid=getVal($loginUserData,"guid","");
        $token=getVal($loginUserData,"token","");
        if($loginUserData && !$guid && $token){
            //需要更新登录信息
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "token"=>$token,
            );
            $checkResult=app("L_Api_goods")->parseToken($paramsObj);
            if($checkResult["error_no"]=="0"){
                $result=$checkResult["result"];
                if($result){
                    $data=$result["data"]?toJsonDecode($result["data"]):array();
                    if($data){
                        if(isset($data["guid"]) && $data["guid"]){
                            //更新授权文件
                            $login_file=runtimePath()."login_file";
                            if(is_file($login_file)){
                                $loginUserData["guid"]=$data["guid"];
                                file_put_contents($login_file,toJsonEncode($loginUserData));
                                //调用更新授权文件接口
                                app("L_Api_goods")->updateKey();
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    /**
     * 添加-分类字段
     */
    public function addCategoryField2(){
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'table_name' => 'category',
            'name' => 'arr_child_id',
            'type' => 'text',
        );
        $checkResult=app("L_table")->addField($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }

        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'table_name' => 'category',
            'name' => 'arr_parent_id',
            'type' => 'varchar',
            'default_value' => '',
            'length' => '255',
        );
        $checkResult=app("L_table")->addField($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }

        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'table_name' => 'category',
            'name' => 'child',
            'type' => 'tinyint',
            'default_value' => '0',
            'length' => '1',
        );
        $checkResult=app("L_table")->addField($paramsObj);
        if($checkResult["error_no"]){
            return false;
        }

        //同步数据
        $checkResult=app("L_Admin_category")->init_category();
        if($checkResult["error_no"]){
            return false;
        }

        return true;
    }

    /**
     * 更新多应用信息[暂时没用上]
     */
    public function updateMultiApp(){
        $app_map=config("app.app_map",array());
        if($app_map){
            if(isset($app_map["admin"])){
                //写入 setting
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'itemKey' => 'backend_name',
                    'itemValue' => $app_map["admin"],
                    'pid' => '1',
                );
                app("L_Admin_setting")->store($paramsObj);
                //同步配置文件

                $config=array();
                $config["app.app_map"]=array();
                upPhpConfig($config); //更新配置文件

                $config=array();
                $config["app.app_map.{$app_map["admin"]}"]="admin";
                upPhpConfig($config); //更新配置文件
            }
        }
        return true;
    }

    /**
     * 优化权限字段
     */
    public function optimize_rbac(){
        /**
         * 安装数据库
         */
        $checkResult=app("LtcmsBackendAccount_L_install")->database();
        if($checkResult["error_no"]){
            return false;
        }

        /**
         * 同步后台账号
         */
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->syncAccount();
        if($checkResult["error_no"]){
            return false;
        }

        /**
         * 初始化权限节点数据
         */
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbac")->initNode();
        if($checkResult["error_no"]){
            return false;
        }

        /**
         * 同步基础功能-权限节点数据
         */
        $menuFile=LTCMS_ROOT."/version/menu/rbac_data.php";
        if(is_file($menuFile)){
            $menuData=include_once $menuFile;
            if($menuData){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "plugins"=>"ltcms@base",
                    "data"=>$menuData,
                );
                $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNode")->import($paramsObj);
                if($checkResult["error_no"]){
                    return false;
                }
            }
        }

        /**
         * 记录rbac权限目录
         */
        $checkResult=app("LtcmsBackendAccount_L_install")->recordRbacPermissionCode();
        if($checkResult["error_no"]){
            return false;
        }
        return true;
    }
}