<?php

namespace plugins\ltcms_backend_account\utils\tool;

class Helper
{
    /**
     * 分类-递归数组
     */
    public static function recursionArr($data,$pid=0)
    {
        $return=array();
        if($data){
            if($pid=="0"){
                $temp=array();
                foreach($data as $val){
                    $temp[$val["pid"]][]=$val;
                }
                $data=$temp;
            }
            $return=isset($data[$pid])?$data[$pid]:array();
            if($return){
                foreach($return as $key=>$val){
                    if(isset($data[$val["id"]]) && $data[$val["id"]]){
                        $return[$key]["child"]=self::recursionArr($data,$val["id"]);
                    }else{
                        $return[$key]["child"]=array();
                    }
                }
            }
        }
        return $return;
    }

    /**
     * 递归数据转换成html
     */
    public static function recursionTohtml($data,$selectId="-1",$level=0)
    {
        $str="";
        $pre=($level==0)?"|— ":str_repeat("&nbsp;&nbsp;&nbsp;",$level)."|— ";
        foreach($data as $key=>$val){
            $checked="";
            if($selectId==$val["id"]){
                $checked="selected";
            }
            $str.="<option value='".$val["id"]."' {$checked} >{$pre}{$val["name"]}</option>";
            if($val["child"]){
                $str.=self::recursionTohtml($val["child"],$selectId,$level+1);
            }
        }
        return $str;
    }

    /**
     * 递归数据转换成 multi html
     */
    public static function recursionToMultihtml($data,$selectMap)
    {
        $selectId=(isset($selectMap["id"]) && $selectMap["id"])?$selectMap["id"]:0;
        $parent=(isset($selectMap["data"]) && $selectMap["data"])?$selectMap["data"]:array();
        $isFind=0;
        $str="<div class='categoryBox'>";
        $count=count($data) -1;
        foreach($data as $key=>$val){
            if($key=="0"){
                $str.="<div class='categoryNav'>";
                $str.="<div class='label'>父级ID({$val['pid']}):&nbsp;&nbsp;</div>";
                $str.="<div class='con'>";
            }
            if($val["id"]==$selectId){
                $isFind=1;
                $str.="<span data-id='{$val["id"]}' class='hand active' >{$val["name"]}</span>";
            }else{
                if($parent && in_array($val["id"],$parent)){
                    $str.="<span data-id='{$val["id"]}' class='hand active' >{$val["name"]}</span>";
                }else{
                    $str.="<span data-id='{$val["id"]}' class='hand' >{$val["name"]}</span>";
                }
            }
            if($key==$count){
                $str.="</div>";
                $str.="</div>";
            }
        }
        foreach($data as $key=>$val){
            if($parent){
                if(in_array($val["id"],$parent)){
                    $str.="<div class='categoryCon' >";
                }else{
                    $str.="<div class='categoryCon' style='display: none;'>";
                }
            }else{
                if($key=="0"){
                    $str.="<div class='categoryCon' >";
                }else{
                    $str.="<div class='categoryCon' style='display: none;'>";
                }
            }
            if($val["child"]){
                if($isFind){
                    $selectMap=array();
                }
                $str.=self::recursionToMultihtml($val["child"],$selectMap);
            }
            $str.="</div>";
        }
        $str.="</div>";
        return $str;
    }
}