<?php

namespace plugins\ltcms_backend_account\utils\encrypt;

class Rsa_aes
{
    /**
     * publicDecrypt
     * 公钥加密
     *
     * @param string $data
     * @param string $key
     * @static
     * @return mixed
     */
    public static function publicEncrypt($data,$key,$padding=OPENSSL_PKCS1_PADDING)
    {
        $aes_key = md5(microtime(true) . mt_rand(0, 1000));
        $data = is_array($data)?json_encode($data):$data;
        $encrypted_data = self::encryptUseAES($data, $aes_key);
        if (openssl_public_encrypt($aes_key, $encrypted_key, $key,$padding)) {
            return base64_encode($encrypted_key) . ':' . $encrypted_data;
        }
        return false;
    }

    /**
     * publicDecrypt
     * 公钥解密
     *
     * @param string $data
     * @param string $key
     * @static
     * @return mixed
     */
    public static function publicDecrypt($data,$key,$padding=OPENSSL_PKCS1_PADDING)
    {
        if (strpos($data, ':') === false) {
            return false;
        }
        list($encrypted_key, $encrypted_data) = explode(':', $data);
        $encrypted_key = base64_decode($encrypted_key);
        if (openssl_public_decrypt($encrypted_key, $aes_key, $key,$padding)) {
            $data = self::decryptUseAES($encrypted_data, $aes_key);
            return $data;
        }
        return false;
    }

    /**
     * 私钥加密
     *
     * @param  string  $value
     * @param  string  $key
     * @return string
     */
    public static function priviteEncrypt($data,$key,$padding=OPENSSL_PKCS1_PADDING){
        $aes_key = md5(microtime(true) . mt_rand(0, 1000));
        $data = is_array($data)?json_encode($data):$data;
        $encrypted_data = self::encryptUseAES($data, $aes_key);
        if (openssl_private_encrypt($aes_key, $encrypted_key, $key,$padding)) {
            return base64_encode($encrypted_key) . ':' . $encrypted_data;
        }
        return false;
    }

    /**
     * 私钥解密
     *
     * @param  string  $value
     * @param  string  $key
     * @return string
     */
    public static function priviteDecrypt($data,$key,$padding=OPENSSL_PKCS1_PADDING){
        if (strpos($data, ':') === false) {
            return false;
        }
        list($encrypted_key, $encrypted_data) = explode(':', $data);
        $encrypted_key = base64_decode($encrypted_key);
        if (openssl_private_decrypt($encrypted_key, $aes_key, $key,$padding)) {
            $data = self::decryptUseAES($encrypted_data, $aes_key);
            return $data;
        }
        return false;
    }

    /**
     * 使用AES基础算法加密数据
     *
     * @param  string  $value
     * @param  string  $key
     * @return string
     */
    public static function encryptUseAES($value, $key)
    {
        return Aes::encrypt($value,$key);
    }

    /**
     * 使用AES基础算法解密数据
     *
     * @param  string  $value
     * @param  string  $key
     * @return string
     */
    public static function decryptUseAES($value, $key)
    {
        return Aes::decrypt($value,$key);
    }
}


