<?php

namespace plugins\ltcms_backend_account\utils\encrypt;

class Aes
{
    private static $method="aes-256-cbc";

    public static function encrypt($data, $key,$method=null) {
        $useMethod=isset($method)?$method:self::$method;
        $ivlen = openssl_cipher_iv_length($useMethod);
        $iv = openssl_random_pseudo_bytes($ivlen);
        $data = openssl_encrypt($data, $useMethod, base64_decode($key), OPENSSL_RAW_DATA,$iv);
        return base64_encode($iv.$data);
    }
    
    public static function decrypt($data, $key,$method=null) {
        $useMethod=isset($method)?$method:self::$method;
        $c = base64_decode($data);
        $ivlen = openssl_cipher_iv_length($useMethod);
        $iv = substr($c, 0, $ivlen);
        $encrypted = substr($c, $ivlen);
        return openssl_decrypt($encrypted,$useMethod, base64_decode($key), OPENSSL_RAW_DATA,$iv);
    }
}


