<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_rbac_role
{
    /**
     * 列表数据
     * @param string $paramObj
     * @return array
     */
    public function listData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'pid' => '',
                'name' => '',
                'is_show' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => $dataObj->request->pid,
                'name' => $dataObj->request->name,
                'is_show' =>$dataObj->request->is_show,
                'field' =>$dataObj->request->field,
                'format' => $dataObj->request->format,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->listData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];

                $format=array();
                $pidIds=array_unique(array_column($result["data"],"pid"));
                if($pidIds){
                    $roleMap=app("LtcmsBackendAccount_L_info")->getRbacRole($pidIds);
                    $format["pid"]=$roleMap;
                }
                $result["data"]=formatData($result["data"],$format);//格式化数据
                $final_arr["result"]=$result;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     * @return array
     */
    public function update($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number|gt:0',
                'name' => 'require',
                'is_show' => 'require',
                'pid' => '',
                'node' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->id,
                'pid' => $dataObj->request->pid,
                'name' => $dataObj->request->name,
                'is_show' =>$dataObj->request->is_show,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->update($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'role_id' => $dataObj->request->id,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0 && $dataObj->request->node) {
            //存入权限数据
            $data=array();
            foreach($dataObj->request->node as $val){
                $data[]=array(
                    "node_id"=>$val,
                    "role_id"=>$dataObj->request->id,
                );
            }
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'data' => $data,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->storeBatch($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($dataObj->data->use_trans){
            if ($final_arr["error_no"]==0) {
                Db()->commit();
            }else{
                Db()->rollback();
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     * @return array
     */
    public function store($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'name' => 'require',
                'is_show' => 'require',
                'pid' => '',
                'node' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => $dataObj->request->pid,
                'name' => $dataObj->request->name,
                'is_show' =>$dataObj->request->is_show,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->store($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->insertId=$checkResult["result"]["id"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'role_id' => $dataObj->data->insertId,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0 && $dataObj->request->node) {
            //存入权限数据
            $data=array();
            foreach($dataObj->request->node as $val){
                $data[]=array(
                    "node_id"=>$val,
                    "role_id"=>$dataObj->data->insertId,
                );
            }
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'data' => $data,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->storeBatch($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $return=array();
            $return["id"]=$dataObj->data->insertId;
            $final_arr["result"]=$return;
        }
        if($dataObj->data->use_trans){
            if ($final_arr["error_no"]==0) {
                Db()->commit();
            }else{
                Db()->rollback();
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     * @return array
     */
    public function delete($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->id,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'role_id' => $dataObj->request->id,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($dataObj->data->use_trans){
            if ($final_arr["error_no"]==0) {
                Db()->commit();
            }else{
                Db()->rollback();
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     * @return array
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'name' => 'require',
                'is_show' => 'require',
                'pid' => '',
                'node' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'name' => $dataObj->request->name,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->infoByName($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $info=$checkResult["result"];
                if($info){
                    $return=array();
                    $return["id"]=$info["id"];
                    $final_arr["result"]=$return;
                }else{
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'name' => $dataObj->request->name,
                        'is_show' => $dataObj->request->is_show,
                        'pid' => $dataObj->request->pid,
                        'node' => $dataObj->request->node,
                    );
                    $checkResult=$this->store($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $id=$checkResult["result"]["id"];
                        $return=array();
                        $return["id"]=$id;
                        $final_arr["result"]=$return;
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}