<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_rbac_node
{
    /**
     * 列表数据
     * @param string $paramObj
     * @return array
     */
    public function listData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'route' => '',
                'search_plugins' => '',
                'right_index' => '',
                'nav_id' => '',
                'name' => '',
                'is_show' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'nav_id' => $dataObj->request->nav_id,
                'name' => $dataObj->request->name,
                'is_show' =>$dataObj->request->is_show,
                'field' =>$dataObj->request->field,
                'format' => $dataObj->request->format,
                'plugins' => $dataObj->request->search_plugins,
                'right_index' => $dataObj->request->right_index,
                'route' => $dataObj->request->route,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->listData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];

                $format=array();
                $navIds=array_unique(array_column($result["data"],"nav_id"));
                if($navIds){
                    $roleMap=app("LtcmsBackendAccount_L_info")->getRbacNav($navIds);
                    $format["nav_id"]=$roleMap;
                }
                $result["data"]=formatData($result["data"],$format);//格式化数据
                $final_arr["result"]=$result;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 复制数据
     * @param string $paramObj
     * @return array
     */
    public function copy($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->id,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $nodeResult=$checkResult["result"];
                if($nodeResult){
                    foreach($nodeResult as $node){
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'name' => $node["name"],
                                'nav_id' => $node["nav_id"],
                                'is_show' => $node["is_show"],
                                'sort' => $node["sort"],
                                'plugins' =>$node["plugins"],
                                'right' =>$node["right"],
                                'right_index' => $node["right_index"],
                            );
                            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->store($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 导出数据
     * @param string $paramObj
     * @return array
     */
    public function export($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'fileName' => 'require',
                'nav' => 'require',
                'node' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->nav,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->getDataById($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $navData=$checkResult["result"];
                $navData=app("ltcmsFormat")->recursionArr($navData);
                $dataObj->data->navData=$navData;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取角色权限
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->node,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                $nodeData=array();
                if($result){
                    foreach($result as $val){
                        $tmp=$val;
                        unset($tmp["nav_id"]);
                        $nodeData[$val["nav_id"]][]=$tmp;
                    }
                }
                $dataObj->data->nodeData=$nodeData;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $joinData = app("LtcmsBackendAccount_L_Admin_rbac")->joinData($dataObj->data->navData, $dataObj->data->nodeData,0);
            $data=array(
                "type"=>"1",
                "data"=>$joinData,
            );
            //写入php文件
            $runtime=runtimePath("cache/navData/{$dataObj->request->fileName}");
            makeDir($runtime);
            $fileName=$runtime."menu.php";
            $fileCode="<?php\n\n \$config= ".var_export($data,true).";\nreturn \$config;";
            file_put_contents($fileName,$fileCode);
        }
        return $final_arr;
    }

    /**
     * 导入菜单
     * @param string $paramObj
     * @return array
     */
    public function import($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'plugins' => 'require',
                'data' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //删除插件
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'plugins' => $dataObj->request->plugins,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->deleteByPlugins($paramsObj);
            if ($checkResult["error_no"] == 0) {

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if(isset($dataObj->request->data["type"])){
                if($dataObj->request->data["type"]=="1"){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'data' => $dataObj->request->data["data"],
                    );
                    $checkResult=$this->record($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            }else{
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'data' => $dataObj->request->data,
                );
                $checkResult=$this->record_v1($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     * @return array
     */
    public function record_v1($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'data' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //递归循环写入数据
            foreach($dataObj->request->data as $val){
                if ($final_arr["error_no"] == 0) {
                    if(!($val["name"] == "网站" && $val["pid"]=="0")){
                        //写入菜单
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'pid' => ($val["pid"]==1)?0:$val["pid"],
                            'name' => $val["name"],
                            'icon' => $val["icon"],
                            'sort' => $val["sort"],
                            'is_show' => $val["status"],
                            'isTop' => $val["isTop"],
                            'plugins' => $val["plugin"]?$val["plugin"]:"",
                        );
                        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->record($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $menuResult=$checkResult["result"];
                            //写入权限节点数据
                            $nodeData=$val["nodeData"];
                            if($nodeData){
                                $nodes=$this->getNodeData_v1($nodeData,$menuResult["id"]);
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "data"=>$nodes,
                                );
                                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->storeBatch($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                }else{
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    //写入子菜单
                    $children=$val["children"];
                    if($children){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'data' => $children,
                        );
                        $checkResult=$this->record_v1($paramsObj);
                        if ($checkResult["error_no"] == 0) {

                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                }
                if ($final_arr["error_no"]) {
                    break;
                }
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     * @return array
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'data' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //递归循环写入数据
            foreach($dataObj->request->data as $val){
                if ($final_arr["error_no"] == 0) {
                    //写入菜单
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'pid' => $val["pid"],
                        'name' => $val["name"],
                        'icon' => $val["icon"],
                        'sort' => $val["sort"],
                        'is_show' => $val["is_show"],
                        'isTop' => $val["isTop"],
                        'plugins' => $val["plugins"]?$val["plugins"]:"",
                    );
                    $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->record($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $menuResult=$checkResult["result"];
                        //写入权限节点数据
                        $nodeData=$val["data"];
                        if($nodeData){
                            $nodes=$this->getNodeData($nodeData,$menuResult["id"]);
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "data"=>$nodes,
                            );
                            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->storeBatch($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    //写入子菜单
                    $children=$val["child"];
                    if($children){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'data' => $children,
                        );
                        $checkResult=$this->record($paramsObj);
                        if ($checkResult["error_no"] == 0) {

                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                }
                if ($final_arr["error_no"]) {
                    break;
                }
            }
        }
        return $final_arr;
    }

    /**
     * 获取节点数据
     * @param $nodeData
     */
    public function getNodeData($nodeData,$nav_id){
        $nodes=array();
        foreach($nodeData as $node){
            $nowTime=app("ltcmsTime")::getTime();
            $nodes[]=array(
                'nav_id' => $nav_id,
                'name' => $node["name"],
                'create_time' => $nowTime,
                'update_time' => $nowTime,
                'is_show' => $node["is_show"],
                'sort' => $node["sort"],
                'right' => $node["right"],
                'route' => $node["route"],
                'plugins' => $node["plugins"],
                'right_index' => $node["right_index"],
            );
        }
        return $nodes;
    }

    /**
     * 获取节点数据
     * @param $nodeData
     */
    public function getNodeData_v1($nodeData,$nav_id){
        $nodes=array();
        foreach($nodeData as $node){
            $nowTime=app("ltcmsTime")::getTime();
            $module=ltrim($node["module"],"/");
            if(!(strpos($module,"plugins/")===0 || strpos($module,"app/")===0)){
                list($appname,$controller)=explode("/",$module);
                $right="app/{$appname}/controller/".$controller;
            }else{
                $right=$module;
            }
            $right=str_replace("/","\\",$right);
            $nodes[]=array(
                'nav_id' => $nav_id,
                'name' => $node["actionName"]?:$node["action"],
                'create_time' => $nowTime,
                'update_time' => $nowTime,
                'is_show' => ($node["isShow"]==1)?1:0,
                'sort' => $node["sort"],
                'right' => toJsonEncode(array(
                    "{$right}@{$node['action']}",
                )),
                'route' => $node["route"],
                'plugins' => $node["plugins"],
                'right_index' => $node["moduleName"]?:$node["actionName"],
            );
        }
        return $nodes;
    }

    /**
     *  更新菜单数据
     * @param string $paramObj
     */
    public function updateData($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'route' => '',
                'plugins' => '',
                'name' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "plugins"=>$dataObj->request->plugins,
                "route"=>$dataObj->request->route,
                "field"=>"id",
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getInfo($paramsObj);
            if($checkResult["error_no"]==0){
                $nodeResult=$checkResult["result"];
                if($nodeResult){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$nodeResult["id"],
                        "name"=>$dataObj->request->name,
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->update($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}