<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_rbac_nav
{
    /**
     * 列表数据
     * @param string $paramObj
     * @return array
     */
    public function listData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'pid' => '',
                'name' => '',
                'is_show' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => $dataObj->request->pid,
                'name' => $dataObj->request->name,
                'is_show' =>$dataObj->request->is_show,
                'field' =>$dataObj->request->field,
                'format' => $dataObj->request->format,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->listData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];

                $format=array();
                $pidIds=array_unique(array_column($result["data"],"pid"));
                if($pidIds){
                    $roleMap=app("LtcmsBackendAccount_L_info")->getRbacNav($pidIds);
                    $format["pid"]=$roleMap;
                }
                $result["data"]=formatData($result["data"],$format);//格式化数据
                $final_arr["result"]=$result;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     * @return array
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'pid' => '',
                'name' => 'require',
                'is_show' => 'require',
                'icon' => '',
                'isTop' => '',
                'plugins' => '',
                'sort' => '',
            );
            $dataDefault=array();
            $dataDefault["plugins"]="";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'name' => $dataObj->request->name,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->infoByName($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $info=$checkResult["result"];
                if($info){
                    $return=array();
                    $return["id"]=$info["id"];
                    $final_arr["result"]=$return;
                }else{
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'name' => $dataObj->request->name,
                        'is_show' => $dataObj->request->is_show,
                        'pid' => $dataObj->request->pid,
                        'icon' => $dataObj->request->icon,
                        'isTop' => $dataObj->request->isTop,
                        'plugins' => $dataObj->request->plugins,
                        'sort' => $dataObj->request->sort,
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->store($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $id=$checkResult["result"]["id"];
                        $return=array();
                        $return["id"]=$id;
                        $final_arr["result"]=$return;
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  置顶文章菜单
     * @param string $paramObj
     */
    public function setTopNav($paramObj="")
    {
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取模块文章数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "module"=>"article",
            );
            $checkResult=app("S_Admin_module")->allData($paramsObj);
            if($checkResult["error_no"]==0){
                $moduleResult=$checkResult["result"];
                if($moduleResult){
                    foreach($moduleResult as $module){
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>$module["name"]."管理",
                                "field"=>"id",
                            );
                            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->infoByName($paramsObj);
                            if($checkResult["error_no"]==0){
                                $navResult=$checkResult["result"];
                                if($navResult){
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "id"=>$navResult["id"],
                                        "isTop"=>"1",
                                    );
                                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->update($paramsObj);
                                    if($checkResult["error_no"]==0){

                                    }else{
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  更新菜单数据
     * @param string $paramObj
     */
    public function updateData($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'plugins' => '',
                'name' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "plugins"=>$dataObj->request->plugins,
                "field"=>"id",
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->infoByName($paramsObj);
            if($checkResult["error_no"]==0){
                $navResult=$checkResult["result"];
                if($navResult){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$navResult["id"],
                        "name"=>$dataObj->request->name,
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->update($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  删除文章菜单
     */
    public function deleteNav($paramObj="")
    {
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "name"=>"后台权限",
				'plugins' => "",
                "field"=>"id",
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->infoByName($paramsObj);
            if($checkResult["error_no"]==0){
                $navResult=$checkResult["result"];
                if($navResult){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$navResult["id"],
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->delete($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}