<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_rbac_admin
{
    public $rand="960af36f93f052854fe6763c492ff375";

    /**
     * 列表数据
     * @param string $paramObj
     * @return array
     */
    public function listData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'status' => '',
                'pid' => '',
                'name' => '',
                'is_show' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => $dataObj->request->pid,
                'name' => $dataObj->request->name,
                'is_show' =>$dataObj->request->is_show,
                'field' =>$dataObj->request->field,
                'format' => $dataObj->request->format,
                'status' => $dataObj->request->status,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->listData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];

                $format=array();
                $roleIds=array_unique(array_column($result["data"],"role_id"));
                if($roleIds){
                    $roleMap=app("LtcmsBackendAccount_L_info")->getRbacRole($roleIds);
                    $format["role_id"]=$roleMap;
                }
                $result["data"]=formatData($result["data"],$format);//格式化数据
                $final_arr["result"]=$result;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 创建资源
     * @param string $paramObj
     * @return array
     */
    public function store($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'account' => 'require',
                'pwd' => 'require',
                'role_id' => '',
                'status' => '',
                'is_supper' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //密码加密
            $dataObj->data->salt=app("LtcmsBackendAccount_P_Rand")->generateRandomString(5,8);
            $mixPwd=trim($dataObj->request->pwd).$dataObj->data->salt;
            $result=app("LtcmsBackendAccount_P_HashPbkdf2")->encrypt($mixPwd);
            if($result===false){
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }else{
                $dataObj->data->pwd=$result;
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'account' => $dataObj->request->account,
                'pwd' => $dataObj->data->pwd,
                'role_id' =>$dataObj->request->role_id,
                'salt' =>$dataObj->data->salt,
                'status' =>$dataObj->request->status,
                'is_supper' =>$dataObj->request->is_supper,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->store($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新资源
     * @param string $paramObj
     * @return array
     */
    public function update($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number|gt:0',
                'role_id' => '',
                'status' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->id,
                'role_id' =>$dataObj->request->role_id,
                'status' =>$dataObj->request->status,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->update($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 记录资源
     * @param string $paramObj
     * @return array
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'account' => 'require',
                'pwd' => 'require',
                'role_id' => '',
                'status' => '',
                'salt' => '',
                'is_supper' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'account' => $dataObj->request->account,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->infoByAccount($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                if(!$result){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'account' => $dataObj->request->account,
                        'pwd' => $dataObj->request->pwd,
                        'role_id' => $dataObj->request->role_id,
                        'status' => $dataObj->request->status,
                        'salt' => $dataObj->request->salt,
                        'is_supper' => $dataObj->request->is_supper,
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->store($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更改密码
     * @param string $paramObj
     * @return array
     */
    public function changePwd($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number|gt:0',
                'pwd' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //密码加密
            $dataObj->data->salt=app("LtcmsBackendAccount_P_Rand")->generateRandomString(5,8);
            $mixPwd=trim($dataObj->request->pwd).$dataObj->data->salt;
            $result=app("LtcmsBackendAccount_P_HashPbkdf2")->encrypt($mixPwd);
            if($result===false){
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }else{
                $dataObj->data->pwd=$result;
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->id,
                'pwd' => $dataObj->data->pwd,
                'salt' =>$dataObj->data->salt,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->changePwd($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 初始化账号
     * @param string $paramObj
     * @return array
     */
    public function initAccount($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'account' => 'admin',
                'pwd' => 'asdasd',
            );
            $checkResult=$this->store($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 创建目录
     * @param $dir
     */
    public function make_dir($dir){
        if(!is_dir($dir)){
            @umask(000);
            mkdir($dir,0755,true);
        }
    }

    /**
     * 同步角色数据
     * @param string $paramObj
     * @return array
     */
    public function syncRole($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取角色数据
            $checkResult=app("S_Admin_adminRole")->getAll();
            if ($checkResult["error_no"] == 0) {
                $roles=$checkResult["result"];
                if($roles){
                    $roleCachesFile=runtimePath("tmp/{$this->rand}")."roleCachesFile";
                    if(!is_file($roleCachesFile)){
                        $this->make_dir(dirname($roleCachesFile));
                        $roleCaches=array();
                        foreach($roles as $role){
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'name' =>$role["name"],
                                    'is_show' => $role["status"],
                                    'pid' => 0,
                                );
                                $checkResult=app("LtcmsBackendAccount_L_Admin_rbacRole")->record($paramsObj);
                                if ($checkResult["error_no"] == 0) {
                                    $roleId=$checkResult["result"]["id"];
                                    $roleCaches[$role["id"]]=$roleId;
                                }else{
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            if($roleCaches){
                                //记录缓存
                                file_put_contents($roleCachesFile,toJsonEncode($roleCaches));
                            }
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取角色缓存同步
     * @return array|mixed|string
     */
    public function getRoleCachesFile(){
        $return=array();
        $roleCachesFile=runtimePath("tmp/{$this->rand}")."roleCachesFile";
        if(is_file($roleCachesFile)){
            $return=toJsonDecode(file_get_contents($roleCachesFile));
        }
        return $return;
    }

    /**
     * 获取菜单缓存同步
     * @return array|mixed|string
     */
    public function getNavCachesFile(){
        $return=array();
        $navCachesFile=runtimePath("tmp/{$this->rand}")."navCachesFile";
        if(is_file($navCachesFile)){
            $return=toJsonDecode(file_get_contents($navCachesFile));
        }
        return $return;
    }

    /**
     * 同步账号数据
     * @param string $paramObj
     * @return array
     */
    public function syncAdmin($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取旧账号
            $checkResult=app("S_Admin_memberAdmin")->getData();
            if ($checkResult["error_no"] == 0) {
                $admins=$checkResult["result"];
                if($admins){
                    $adminsFile=runtimePath("tmp/{$this->rand}")."adminsFile";
                    if(!is_file($adminsFile)){
                        $this->make_dir(dirname($adminsFile));
                        $roleCaches=$this->getRoleCachesFile();
                        foreach($admins as $admin){
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'is_supper' => $admin["isAdmin"],
                                    'account' => $admin["user"],
                                    'pwd' => $admin["password"],
                                    'role_id' => $roleCaches[$admin["roleId"]]?:0,
                                    'salt' => '',
                                    'status' => '1',
                                );
                                $checkResult=$this->record($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                }else{
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //记录缓存
                            file_put_contents($adminsFile,1);
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 同步菜单数据
     * @param string $paramObj
     * @return array
     */
    public function syncNav($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取菜单数据
            $checkResult=app("S_Admin_adminMenu")->getAll();
            if ($checkResult["error_no"] == 0) {
                $menuResult=$checkResult["result"];
                if($menuResult){
                    $navCachesFile=runtimePath("tmp/{$this->rand}")."navCachesFile";
                    if(!is_file($navCachesFile)){
                        $this->make_dir(dirname($navCachesFile));
                        $menuCaches=array();
                        foreach($menuResult as $menu){
                            if ($final_arr["error_no"] == 0) {
                                if($menu["pid"]=="1"){
                                    $plugin="";
                                    if($menu["plugin"]){
                                        $plugin=$menu["plugin"];
                                        if(strpos($menu["plugin"],"plugins/")===0){
                                            $plugin=str_replace("plugins/","",$plugin);
                                        }
                                    }
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        'pid' => 0,
                                        'name' => $menu["name"],
                                        'is_show' => $menu["status"],
                                        'icon' => $menu["icon"],
                                        'isTop' => $menu["isTop"],
                                        'plugins' => $plugin,
                                        'sort' => $menu["sort"],
                                    );
                                    $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->record($paramsObj);
                                    if ($checkResult["error_no"] == 0) {
                                        $menuCaches[$menu["id"]]=$checkResult["result"]["id"];
                                    }else{
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            if($navCachesFile){
                                //记录缓存
                                file_put_contents($navCachesFile,toJsonEncode($menuCaches));
                            }
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 同步权限数据
     * @param string $paramObj
     * @return array
     */
    public function syncAccess($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取对应关系
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getData();
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                $nodeMap=array();
                foreach ($result as $node){
                    $nodeMap[$node["old_id"]]=$node["id"];
                }
                $dataObj->data->nodeMap=$nodeMap;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取权限
            $checkResult=app("S_Admin_adminRoleFunc")->getData();
            if ($checkResult["error_no"] == 0) {
                $accessResult=$checkResult["result"];
                if($accessResult){
                    $accessCachesFile=runtimePath("tmp/{$this->rand}")."accessCachesFile";
                    if(!is_file($accessCachesFile)){
                        $this->make_dir(dirname($accessCachesFile));
                        $roleCaches=$this->getRoleCachesFile();
                        $access=array();
                        foreach($accessResult as $val){
                            if ($final_arr["error_no"] == 0) {
                                $access[]=array(
                                    'role_id' => $roleCaches[$val["roleId"]],
                                    'node_id' => $dataObj->data->nodeMap[$val["funcId"]],
                                );
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "data"=>$access,
                            );
                            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->storeBatch($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            if($accessCachesFile){
                                //记录缓存
                                file_put_contents($accessCachesFile,1);
                            }
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 同步节点数据
     * @param string $paramObj
     * @return array
     */
    public function syncNode($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //同步权限
            $checkResult=app("S_Admin_adminFunc")->getData();
            if ($checkResult["error_no"] == 0) {
                $funcResult=$checkResult["result"];
                if($funcResult){
                    $nodeCachesFile=runtimePath("tmp/{$this->rand}")."nodeCachesFile";
                    if(!is_file($nodeCachesFile)){
                        $this->make_dir(dirname($nodeCachesFile));
                        $navCaches=$this->getNavCachesFile();
                        $nodes=array();
                        foreach($funcResult as $func){
                            if ($final_arr["error_no"] == 0) {
                                if($func["menuId"] && $func["plugins"]){
                                    //存入信息
                                    $nav_id=$navCaches[$func["menuId"]];
                                    $module=ltrim($func["module"],"/");
                                    if(!(strpos($module,"plugins/")===0 || strpos($module,"app/")===0)){
                                        list($appname,$controller)=explode("/",$module);
                                        $right="app/{$appname}/controller/".$controller;
                                    }else{
                                        $right=$module;
                                    }
                                    if($nav_id){
                                        $right=str_replace("/","\\",$right);
                                        $nowTime=app("ltcmsTime")::getTime();

                                        $plugin=$func["plugins"];
                                        if(strpos($plugin,"plugins/")===0){
                                            $plugin=str_replace("plugins/","",$plugin);
                                        }

                                        $nodes[]=array(
                                            'name' => $func["actionName"]?:$func["action"],
                                            'nav_id' => $nav_id,
                                            'is_show' => ($func["isShow"]==1)?1:0,
                                            'sort' => $func["sort"],
                                            'route' => $func["route"],
                                            'plugins' => $plugin,
                                            'create_time' => $nowTime,
                                            'update_time' => $nowTime,
                                            'right_index' => $func["moduleName"]?:$func["actionName"],
                                            'old_id' => $func["id"],
                                            'right' => toJsonEncode(array(
                                                "{$right}@{$func['action']}",
                                            )),
                                        );
                                    }
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                        if($nodes){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "data"=>$nodes,
                            );
                            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->storeBatch($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            if($nodeCachesFile){
                                //记录缓存
                                file_put_contents($nodeCachesFile,1);
                            }
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 矫正nav数据
     * @param string $paramObj
     * @return array
     */
    public function correctNav($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //同步权限
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getData();
            if ($checkResult["error_no"] == 0) {
                $funcResult=$checkResult["result"];
                if($funcResult){
                    $correctNavCachesFile=runtimePath("tmp/{$this->rand}")."correctNavCachesFile";
                    if(!is_file($correctNavCachesFile)){
                        $this->make_dir(dirname($correctNavCachesFile));
                        $menus=array();
                        foreach($funcResult as $func){
                            if ($final_arr["error_no"] == 0) {
                                if($func["nav_id"] && $func["plugins"]){
                                    if(!isset($menus[$func["nav_id"]])){
                                        $menus[$func["nav_id"]]=$func["plugins"];
                                    }
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                        if($menus){
                            foreach($menus as $nav_id=>$plugins){
                                if ($final_arr["error_no"] == 0) {
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "id"=>$nav_id,
                                        "plugins"=>$plugins,
                                    );
                                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->update($paramsObj);
                                    if ($checkResult["error_no"] == 0) {

                                    }else{
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                                if ($final_arr["error_no"]) {
                                    break;
                                }
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            if($correctNavCachesFile){
                                //记录缓存
                                file_put_contents($correctNavCachesFile,1);
                            }
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 创建文章菜单
     * @param string $paramObj
     * @return array
     */
    public function createArticleNodes($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $createArticleNodesCachesFile=runtimePath("tmp/{$this->rand}")."createArticleNodesCachesFile";
            if(!is_file($createArticleNodesCachesFile)){
                if ($final_arr["error_no"] == 0) {
                    $checkResult=app("L_Admin_module")->createNode();
                    if ($checkResult["error_no"] == 0) {

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    if($createArticleNodesCachesFile){
                        //记录缓存
                        file_put_contents($createArticleNodesCachesFile,1);
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 置顶文章菜单
     * @param string $paramObj
     * @return array
     */
    public function setTopNav($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $setTopNavCachesFile=runtimePath("tmp/{$this->rand}")."setTopNavCachesFile";
            if(!is_file($setTopNavCachesFile)){
                if ($final_arr["error_no"] == 0) {
                    $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->setTopNav();
                    if ($checkResult["error_no"] == 0) {

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    if($setTopNavCachesFile){
                        //记录缓存
                        file_put_contents($setTopNavCachesFile,1);
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 删除文章菜单
     * @param string $paramObj
     * @return array
     */
    public function deleteNav($paramObj=""){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $deleteNavCachesFile=runtimePath("tmp/{$this->rand}")."deleteNavCachesFile";
            if(!is_file($deleteNavCachesFile)){
                if ($final_arr["error_no"] == 0) {
                    $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->deleteNav();
                    if ($checkResult["error_no"] == 0) {

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    if($deleteNavCachesFile){
                        //记录缓存
                        file_put_contents($deleteNavCachesFile,1);
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 同步数据
     * @param string $paramObj
     * @return array
     */
    public function syncAccount($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //同步角色数据
            $checkResult=$this->syncRole();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //同步账号
            $checkResult=$this->syncAdmin();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //同步菜单数据
            $checkResult=$this->syncNav();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //同步节点数据
            $checkResult=$this->syncNode();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //同步权限数据
//            $checkResult=$this->syncAccess();
//            if ($checkResult["error_no"] == 0) {
//
//            }else{
//                $final_arr = logCallErrorMsg($final_arr, $checkResult);
//            }
        }
        if ($final_arr["error_no"] == 0) {
            //矫正nav数据
//            $checkResult=$this->correctNav();
//            if ($checkResult["error_no"] == 0) {
//
//            }else{
//                $final_arr = logCallErrorMsg($final_arr, $checkResult);
//            }
        }
        if ($final_arr["error_no"] == 0) {
            //创建文章菜单
            $checkResult=$this->createArticleNodes();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //置顶文章菜单
            $checkResult=$this->setTopNav();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //删除文章菜单
            $checkResult=$this->deleteNav();
            if ($checkResult["error_no"] == 0) {

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}