<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_rbac
{
    /**
     * 初始化数据
     * @param string $paramObj
     */
    public function initData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $plugins="ltcms_backend_account";
            //写入数据
            $menuFile=LTCMS_ROOT."/plugins/{$plugins}/install/rbac_data.php";
            if(is_file($menuFile)){
                $menuData=include_once $menuFile;
                if($menuData){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "plugins"=>"",
                        "data"=>$menuData,
                    );
                    $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNode")->import($paramsObj);
                    if($checkResult["error_no"]=="0"){

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 初始化节点
     * @param string $paramObj
     * @return array
     */
    public function initNode($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //添加菜单
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "name"=>"权限管理",
                "icon"=>"icon-tuozhan",
                "is_show"=>"1",
                "isTop"=>"10",
                "sort"=>"200",
            );
            $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->record($paramsObj);
            if($checkResult["error_no"]==0){
                $navResult=$checkResult["result"];
                $nodes=$this->getRbacNodes($navResult["id"]);
                if($nodes){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "data"=>$nodes,
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->storeBatch($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取权限节点数据
     * @param $module
     * @return array
     */
    public function getRbacNodes($nav_id){
        $nodes=array();
        $plugins="ltcms_backend_account";

        /**
         * 用户账号
         */
        $nodes[]=$this->getNode("用户列表",$nav_id,1,10,"ltcms_backend_account/rbacAdmin","rbac管理员",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_admin@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","rbac管理员",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_admin@create',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","rbac管理员",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_admin@edit',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","rbac管理员",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_admin@delete',
        ),$plugins);
        $nodes[]=$this->getNode("改密码",$nav_id,0,40,"ltcms_backend_account/rbacAdmin/changePwd","rbac管理员",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_admin@changePwd',
            'plugins\ltcms_backend_account\admin\controller\Rbac_admin@changePwdExec',
        ),$plugins);

        /**
         * 角色列表
         */
        $nodes[]=$this->getNode("角色列表",$nav_id,1,20,"ltcms_backend_account/rbacRole","rbac角色",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_role@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","rbac角色",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_role@create',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","rbac角色",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_role@edit',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","rbac角色",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_role@delete',
        ),$plugins);

        /**
         * 菜单列表
         */
        $nodes[]=$this->getNode("菜单列表",$nav_id,1,30,"ltcms_backend_account/rbacNav","rbac菜单",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_nav@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","rbac菜单",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_nav@create',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","rbac菜单",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_nav@edit',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","rbac菜单",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_nav@delete',
        ),$plugins);

        /**
         * 节点列表
         */
        $nodes[]=$this->getNode("节点列表",$nav_id,1,40,"ltcms_backend_account/rbacNode","rbac节点",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","rbac节点",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@create',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","rbac节点",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@edit',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","rbac节点",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@delete',
        ),$plugins);
        $nodes[]=$this->getNode("复制",$nav_id,0,40,"","rbac节点",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@copy',
        ),$plugins);
        $nodes[]=$this->getNode("导出",$nav_id,0,50,"","rbac节点",array(
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@export',
            'plugins\ltcms_backend_account\admin\controller\Rbac_node@exportExec',
        ),$plugins);

        /**
         * 权限目录
         */
        $nodes[]=$this->getNode("权限目录",$nav_id,1,40,"ltcms_backend_account/permissionCode","rbac权限目录",array(
            'plugins\ltcms_backend_account\admin\controller\Permission_code@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","rbac权限目录",array(
            'plugins\ltcms_backend_account\admin\controller\Permission_code@create',
            'plugins\ltcms_backend_account\admin\controller\Permission_code@listAction',
            'plugins\ltcms_backend_account\admin\controller\Permission_code@listController',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","rbac权限目录",array(
            'plugins\ltcms_backend_account\admin\controller\Permission_code@edit',
            'plugins\ltcms_backend_account\admin\controller\Permission_code@listAction',
            'plugins\ltcms_backend_account\admin\controller\Permission_code@listController',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","rbac权限目录",array(
            'plugins\ltcms_backend_account\admin\controller\Permission_code@delete',
        ),$plugins);
        return $nodes;
    }

    /**
     * 获取节点
     */
    public function getNode($name,$nav_id,$is_show,$sort,$route,$right_index,$right,$plugins=""){
        $nowTime=app("ltcmsTime")::getTime();
        return array(
            "name"=>$name,
            "nav_id"=>$nav_id,
            "create_time"=>$nowTime,
            "update_time"=>$nowTime,
            'is_show' => $is_show,
            'sort' => $sort,
            'route' => $route,
            'right_index' => $right_index,
            'right' => toJsonEncode($right),
            'plugins' => $plugins,
        );
    }

    /**
     * 权限列表
     * @param string $paramObj
     * @return array
     */
    public function permissionList($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $checkResult=$this->navData();
            if ($checkResult["error_no"] == 0) {
                $navData=$checkResult["result"];
                $navData=app("ltcmsFormat")->recursionArr($navData);
                $dataObj->data->navData=$navData;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取角色权限
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'is_super' => 1,
            );
            $checkResult=$this->nodeData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->nodeData=$this->formatNodeData($checkResult["result"]);
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $joinData = $this->joinData($dataObj->data->navData, $dataObj->data->nodeData,0);
            $final_arr["result"]=$joinData;
        }
        return $final_arr;
    }

    /**
     * 格式化节点数据
     * @param $nodeData
     */
    public function formatNodeData($nodeData){
        $return=array();
        foreach($nodeData as $nav_id=>$node){
            foreach($node as $val){
                $return[$nav_id][$val["right_index"]][]=$val;
            }
        }
        return $return;
    }

    /**
     * 获取菜单数据
     * @param string $paramObj
     * @return array
     */
    public function menuData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'uid' => 'require',
                'nav_id' => '',
            );
            $dataDefault=array();
            $dataDefault["nav_id"]=0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取当前登录信息
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->uid,
                'field' => "account,role_id,id,is_supper",
                "verify" => 1,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->adminResult=$checkResult["result"];
                $dataObj->data->is_super=$dataObj->data->adminResult["is_supper"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取菜单数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'nav_id' => $dataObj->request->nav_id,
            );
            $checkResult=$this->navData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $navResult=$checkResult["result"];
                $dataObj->data->navData=app("ltcmsFormat")->recursionArr($navResult);
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取角色权限
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'role_id' => $dataObj->data->adminResult["role_id"],
                'is_super' => $dataObj->data->is_super,
                'is_show' => 1,
            );
            $checkResult=$this->nodeData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->nodeData=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $joinData = $this->joinData($dataObj->data->navData, $dataObj->data->nodeData);
            $final_arr["result"]=$joinData;
        }
        return $final_arr;
    }

    /**
     * 组合数据
     * @param $navData
     * @param $nodeData
     */
    public function joinData($navData,$nodeData,$remove_empty=1){
        foreach($navData as $key=>$val){
            if(isset($nodeData[$val["id"]])){
                $navData[$key]["data"]=$nodeData[$val["id"]];
            }
            if($val["child"]){
                $child=$this->joinData($val["child"],$nodeData,$remove_empty);
                if($child){
                    $navData[$key]["child"]=$child;
                }else{
                    if($remove_empty){
                        unset($navData[$key]);
                    }
                }
            }else{
                if($remove_empty){
                    if(!isset($nodeData[$val["id"]])){
                        unset($navData[$key]);
                    }
                }
            }
        }
        return $navData;
    }

    /**
     * 获取节点数据
     * @param string $paramObj
     * @return array
     */
    public function navData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'nav_id' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->nav_id){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->request->nav_id,
                    "field"=>"id,name,pid,icon",
                );
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->getChildData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->data->navData=$checkResult["result"];
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else{
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "field"=>"id,name,pid,icon",
                    "is_show"=>"1",
                );
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->getData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->data->navData=$checkResult["result"];
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $final_arr["result"]=$dataObj->data->navData;
        }
        return $final_arr;
    }

    /**
     * 获取节点数据
     * @param string $paramObj
     * @return array
     */
    public function nodeData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'role_id' => '',
                'is_super' => '',
                'purpose' => '',
                'is_show' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->is_super){
                if($dataObj->request->purpose=="permission"){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'field' => 'id,name,right,nav_id,route',
                    );
                }else{
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'field' => 'id,name,nav_id,route,right_index',
                        'is_show' => $dataObj->request->is_show,
                    );
                }
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    $return=array();
                    if($result){
                        foreach($result as $val){
                            $tmp=$val;
                            unset($tmp["nav_id"]);
                            $return[$val["nav_id"]][]=$tmp;
                        }
                    }
                    $final_arr["result"]=$return;
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else{
                if($dataObj->request->role_id){
                    //检验角色状态
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'id' =>$dataObj->request->role_id,
                        'field' =>"id",
                        'is_show' =>"1",
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->getData($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $roleResult=$checkResult["result"];
                        if($roleResult){
                            $roleIds=array_column($roleResult,"id");
                            //获取指定角色节点数据
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'role_id' =>$roleIds,
                            );
                            $checkResult=$this->accessData($paramsObj);
                            if ($checkResult["error_no"] == 0) {
                                $accessResult=$checkResult["result"];
                                $nodeIds=$accessResult?array_column($accessResult,"node_id"):array();
                                if($nodeIds){
                                    if($dataObj->request->purpose=="permission"){
                                        $paramsObj=paramsObj();
                                        $paramsObj->params=array(
                                            'field' => 'id,name,right,nav_id,route',
                                            'id' => $nodeIds,
                                        );
                                    }else{
                                        $paramsObj=paramsObj();
                                        $paramsObj->params=array(
                                            'field' => 'id,name,nav_id,route,right_index',
                                            'is_show' => $dataObj->request->is_show,
                                            'id' => $nodeIds,
                                        );
                                    }
                                    $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->getData($paramsObj);
                                    if ($checkResult["error_no"] == 0) {
                                        $result=$checkResult["result"];
                                        $return=array();
                                        if($result){
                                            foreach($result as $val){
                                                $tmp=$val;
                                                unset($tmp["nav_id"]);
                                                $return[$val["nav_id"]][]=$tmp;
                                            }
                                        }
                                        $final_arr["result"]=$return;
                                    }else{
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 获取节点关系数据
     * @param string $paramObj
     * @return array
     */
    public function accessData($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'role_id' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取角色权限
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'role_id' =>$dataObj->request->role_id,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAccess")->getData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 检查 是否需要认证
     * @return bool
     */
    public function checkAccess()
    {
        $module_name=request()->controller_full();
        $action_name=request()->action();
        //如果项目要求认证，并且当前模块需要认证，则进行权限认证
        if(configPlugin('ltcms_backend_account.rbac.user_auth_on',false)){
            $_module	=	array();
            $_action	=	array();
            if(configPlugin('ltcms_backend_account.rbac.not_auth_module',array())) {
                //无需认证的模块
                $_module['no'] = array_map("strtoupper",configPlugin('ltcms_backend_account.rbac.not_auth_module',array()));
            }
            //检查当前模块是否需要认证
            if((!empty($_module['no']) && !in_array(strtoupper($module_name),$_module['no'])) || empty($_module['no'])) {
                if(configPlugin('ltcms_backend_account.rbac.not_auth_action',array())) {
                    //无需认证的操作
                    $_action['no'] = array_map("strtoupper",configPlugin('ltcms_backend_account.rbac.not_auth_action',array()));
                }
                //检查当前操作是否需要认证
                if((!empty($_action['no']) && !in_array(strtoupper($action_name),$_action['no'])) || empty($_action['no'])) {
                    return true;
                }else {
                    return false;
                }
            }else {
                return false;
            }
        }
        return false;
    }

    /**
     * 用于检测用户权限的方法,并保存到Session中
     */
    public function saveAccessList($authId=null)
    {
        $is_supper=session()->get("ltcmsBackendAccount_supper",0);
        if(!$is_supper){
            if(null===$authId){
                $authId=session()->get("ltcmsBackendAccount_uid","");
            }
            // 如果使用普通权限模式，保存当前用户的访问权限列表
            // 对管理员开发所有权限
            if(configPlugin('ltcms_backend_account.rbac.user_auth_type') !=2 && $authId){
                $paramsObj=paramsObj();
                $paramsObj->params=array();
                $paramsObj->params["uid"]=$authId;
                $checkResult=$this->accessList($paramsObj);
                if($checkResult["error_no"]==0){
                    $accessList=$checkResult["result"];
                }else{
                    $accessList=array();
                }
                session()->set("_ACCESS_LIST",$accessList);
            }
        }
    }

    /**
     * 获取权限列表
     */
    public function accessList($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'uid' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取账号信息
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'id' => $dataObj->request->uid,
                'field' => "account,role_id,id,is_supper",
                "verify" => 1,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->adminResult=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $access=array();
            $auth_no=configPlugin("ltcms_backend_account.rbac.no",array());
            foreach($auth_no as $module_name=>$authoritys_list)
            {
                foreach($authoritys_list as $authority_item)
                {
                    $access[strtoupper($module_name)][strtoupper($authority_item)] =  true;
                }
            }
            if ($final_arr["error_no"] == 0) {
                //获取角色权限
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'role_id' => $dataObj->data->adminResult["role_id"],
                    'is_super' => $dataObj->data->adminResult["is_supper"],
                    'purpose' => "permission",
                );
                $checkResult=$this->nodeData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $nodeResult=$checkResult["result"];
                    //提取权限数据
                    if($nodeResult){
                        $auth_all=configPlugin("ltcms_backend_account.rbac.all",array());
                        $permissionData=$this->getPermissionData($nodeResult);
                        foreach($permissionData as $app_val){
                            $o_module_name=strtoupper($app_val["module"]);
                            $o_action_name=strtoupper($app_val["action"]);
                            $l_module_name=strtolower($app_val["module"]);
                            $l_action_name=strtolower($app_val["action"]);
                            if(isset($auth_all[$l_action_name]) && $auth_all[$l_action_name])
                            {
                                $authoritys_list = $auth_all[$l_action_name];
                                foreach($authoritys_list as $authority_item)
                                {
                                    $access[$o_module_name][strtoupper($authority_item)] =  true;
                                }
                            }
                            $access[$o_module_name][$o_action_name] =  true;
                        }
                    }
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
            if ($final_arr["error_no"] == 0) {
                $final_arr["result"]=$access;
            }
        }
        return $final_arr;
    }

    /**
     * 获取权限数据
     */
    public function getPermissionData($nodeResult){
        $result=array();
        if($nodeResult){
            foreach($nodeResult as $node){
                foreach($node as $value){
                    $rights=$value["right"]?json_decode($value["right"],true):array();
                    if($rights){
                        foreach($rights as $right){
                            list($module,$action)=explode("@",$right);
                            $result[]=array(
                                "module"=>$module,
                                "action"=>$action,
                            );
                        }
                    }
                }
            }
        }
        return $result;
    }

    /**
     * 权限认证的过滤器方法
     */
    public function accessDecision()
    {
        $module_name=request()->controller_full();
        $action_name=request()->action();

        $is_supper=session()->get("ltcmsBackendAccount_supper",0);
        if($is_supper){
            return true;
        }
        if($this->checkAccess()) {
            $accessGuid   =   md5($module_name."@".$action_name);
            if( session()->get($accessGuid,"")) {
                return true;
            }
            if(configPlugin('ltcms_backend_account.rbac.user_auth_type')==2) {
                $user_auth_id=session()->get("ltcmsBackendAccount_uid","");
                $paramsObj=paramsObj();
                $paramsObj->params=array();
                $paramsObj->params["uid"]=$user_auth_id;
                $checkResult = $this->accessList($paramsObj);
                if($checkResult["error_no"]==0){
                    $accessList=$checkResult["result"];
                }else{
                    $accessList=array();
                }
            }else {
                $accessList = session()->get('_ACCESS_LIST',array());
            }
            if(!isset($accessList[strtoupper($module_name)][strtoupper($action_name)])) {
                session()->set($accessGuid,false);
                return false;
            }else{
                session()->set($accessGuid,true);
                return true;
            }
        }
        return true;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}