<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_permission_code
{
    /**
     * 控制器列表
     * @param string $paramObj
     * @return array
     */
    public function listController($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $checkResult=app("LtcmsBackendAccount_S_Admin_permissionCode")->getData();
            if ($checkResult["error_no"] == 0) {
                $data=$checkResult["result"];
                $controller=array();
                if($data){
                    foreach($data as $val){
                        $temp=$this->getController($val["path"],$val["name"]);
                        $controller=array_merge($controller,$temp);
                    }
                }
                $return=array();
                $return["controller"]=$controller;
                $final_arr["result"]=$return;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取控制器列表
     * @param $dir
     */
    public function getController($dir,$rname){
        $rootBath=app()->getRootPath();
        $dir=rtrim(parseDir($dir),DIRECTORY_SEPARATOR);
        $filePath=$rootBath.$dir.DIRECTORY_SEPARATOR;
        $funcs=glob($filePath."*.php");
        $controller=array();
        if($funcs){
            foreach($funcs as $val){
                $name=basename($val,".php");
                $path=str_replace(array("/"),"\\",$dir.DIRECTORY_SEPARATOR.$name);
                $controller[]=array(
                    "name"=>$rname."@".$name,
                    "path"=>$path,
                );
            }
        }
        return $controller;
    }

    /**
     * 方法列表
     * @param string $paramObj
     * @return array
     */
    public function listAction($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'controller' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $action=$this->getAction($dataObj->request->controller);
            $return=array();
            $return["action"]=$action;
            $final_arr["result"]=$return;
        }
        return $final_arr;
    }

    /**
     * 获取控制器方法列表
     * @param $dir
     */
    public function getAction($controller){
        $controller=str_replace(array("/"),"\\",$controller);
        $action=array();
        $class = new \ReflectionClass($controller);
        $methods = $class->getMethods();
        foreach($methods  as $method){
            if($method->isPublic() && !$method->isConstructor() && !$method->isDestructor()){
                $action[]=array(
                    "name"=>$method->name,
                );
            }
        }
        return $action;
    }

    /**
     * 录入数据
     * @param string $paramObj
     * @return array
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'plugins' => '',
                'data' => 'require',
            );
            $dataDefault=array();
            $dataDefault["plugins"]="";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //删除当前数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'plugins' => $dataObj->request->plugins,
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_permissionCode")->deleteByPlugins($paramsObj);
            if ($checkResult["error_no"] == 0) {

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->data && is_array($dataObj->request->data)){
                $data=array();
                foreach($dataObj->request->data as $val){
                    $nowTime=app("ltcmsTime")::getTime();
                    $temp=array();
                    $temp["name"]=$val["name"];
                    $temp["path"]=$val["path"];
                    $temp["plugins"]=$dataObj->request->plugins;
                    $temp["is_show"]=$val["is_show"];
                    $temp["create_time"]=$nowTime;
                    $temp["update_time"]=$nowTime;
                    $data[]=$temp;
                }
                if($data){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'data' => $data,
                    );
                    $checkResult=app("LtcmsBackendAccount_S_Admin_permissionCode")->storeBatch($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}