<?php

namespace plugins\ltcms_backend_account\logic\admin;

class L_login
{
    /**
     * 登录
     */
    public function login($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'account' => 'require',
                'password' => 'require',
                'captcha' => 'require',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $captcha_txt=session()->get("captcha_txt");
            if(!$captcha_txt || $dataObj->request->captcha != $captcha_txt){
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, langPlugin("ltcms_backend_account.admin.captchaError"));
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取账号信息
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'account' => $dataObj->request->account,
                'field' => "id,account,salt,pwd,role_id,is_supper",
            );
            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->infoByAccount($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $userResult=$checkResult["result"];
                if($userResult){
                    $mixPwd=trim($dataObj->request->password).$userResult["salt"];
                    $comparePwdResult=app("LtcmsBackendAccount_P_HashPbkdf2")->decrypt($mixPwd,$userResult["pwd"]);
                    if($comparePwdResult===false){
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, langPlugin("ltcms_backend_account.admin.pwdError"));
                    }else{
                        //记录登录数据
                        unset($userResult["salt"],$userResult["pwd"]);
                        $this->saveLoginData($userResult);
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, langPlugin("ltcms_backend_account.admin.userEmpty"));
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 存储登录数据
     * @param $userResult
     */
    public function saveLoginData($userResult){
        //保存数据
        session()->set("ltcmsBackendAccount_isLogin", $userResult["id"]?1:0);
        session()->set("ltcmsBackendAccount_uid", $userResult["id"]);
        session()->set("ltcmsBackendAccount_account", $userResult["account"]);
        session()->set("ltcmsBackendAccount_supper", $userResult["is_supper"]);
        session()->set("ltcmsBackendAccount_adminInfo", $userResult);
        app("LtcmsBackendAccount_L_Admin_rbac")->saveAccessList($userResult["id"]);
    }

    /**
     * 获取登录数据
     * @return array
     */
    public function getLoginData(){
        $user=array();
        $user["status"]=session()->get("ltcmsBackendAccount_isLogin",0);
        $user["id"]=session()->get("ltcmsBackendAccount_uid",0);
        $user["supper"]=session()->get("ltcmsBackendAccount_supper",0);
        $user["data"]=session()->get("ltcmsBackendAccount_adminInfo",array());
        return $user;
    }

    /**
     * 退出数据
     */
    public function logout(){
        session()->delete("ltcmsBackendAccount_isLogin");
        session()->delete("ltcmsBackendAccount_uid");
        session()->delete("ltcmsBackendAccount_adminInfo");
        session()->delete("ltcmsBackendAccount_account");
        session()->delete("ltcmsBackendAccount_supper");
        session()->delete("_ACCESS_LIST");
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}