<?php

namespace plugins\ltcms_backend_account\logic;

class L_install
{
    /**
     * 安装数据库
     * @param string $paramObj
     */
    public function database($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //执行sql文件
            $sqlFile=LTCMS_ROOT."/plugins/ltcms_backend_account/install/install.sql";
            if(is_file($sqlFile)){
                $_sql = file_get_contents($sqlFile);
                if($_sql){
                    $db_table_pre=app("cmsTable")::getPre();
                    $_sql=str_replace("\r","",$_sql);
                    $_arr = explode(";\n", $_sql);
                    foreach($_arr as $sql){
                        $sql=trim($sql);
                        if($sql){
                            $sql=str_replace("{table_pre}",$db_table_pre,$sql);
                            $ok=Db()->execute($sql);
                            if(!$ok){
                                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL,"安装失败");
                            }
                        }
                    }
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 后台菜单
     * @param string $paramObj
     */
    public function menu($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'xxx' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $plugins="ltcms_backend_account";
            $menuFile=LTCMS_ROOT."/plugins/{$plugins}/install/menu.php";
            if(is_file($menuFile)){
                //写入后台菜单
                $menuData=include_once $menuFile;
                if($menuData){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "plugins"=>$plugins,
                        "data"=>$menuData,
                    );
                    $checkResult=app("L_Admin_adminMenu")->recordMenu($paramsObj);
                    if($checkResult["error_no"]=="0"){

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 记录rbac权限目录
     * @param string $paramObj
     */
    public function recordRbacPermissionCode($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $data=array();
            $data[]=array(
                "plugins"=>"",
                "data"=>array(
                    array(
                        "name"=>"应用-后台",
                        "path"=>'app\admin\controller',
                        "is_show"=>"1",
                    ),
                ),
            );
            $data[]=array(
                "plugins"=>"ltcms_backend_account",
                "data"=>array(
                    array(
                        "name"=>"rbac权限",
                        "path"=>'plugins\ltcms_backend_account\admin\controller',
                        "is_show"=>"1",
                    ),
                ),
            );
            foreach($data as $val){
                if ($final_arr["error_no"] == 0) {
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'plugins' => $val["plugins"],
                        'data' => $val["data"],
                    );
                    $checkResult=app("LtcmsBackendAccount_L_Admin_PermissionCode")->record($paramsObj);
                    if($checkResult["error_no"]=="0"){

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"]) {
                    break;
                }
            }
        }
        return $final_arr;
    }

    /**
     * 移动静态文件
     */
    public function moveRes(){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $path1 = LTCMS_ROOT . "/plugins/ltcms_backend_account/static";
            if(is_dir($path1)){
                $path2 = LTCMS_ROOT . "/public/static/plugins/ltcms_backend_account";
                dirCopy($path1, $path2);
            }
        }
        return $final_arr;
    }

    /**
     * 删除-静态文件
     */
    public function removeRes(){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $path2 = LTCMS_ROOT . "/public/static/plugins/ltcms_backend_account";
            if(is_dir($path2)){
                dirDelete($path2);
            }
        }
        return $final_arr;
    }
}