<?php

namespace plugins\ltcms_backend_account\logic;

class L_info
{
    /**
     * 获取rbac角色数据
     * @param string $paramObj
     * @return array
     */
    public function getRbacRole($id){
        $roleMap=array();
        $roleIds=is_array($id)?$id:explode(",",$id);
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'id' => $roleIds,
            'field' => "id,name",
        );
        $checkResult=app("LtcmsBackendAccount_S_Admin_rbacRole")->getDataById($paramsObj);
        if ($checkResult["error_no"] == 0) {
            $rbacRoleResult=$checkResult["result"];
            if($rbacRoleResult){
                $roleMap=array_column($rbacRoleResult,"name","id");
            }
        }
        return $roleMap;
    }

    /**
     * 获取rbac菜单数据
     * @param string $paramObj
     * @return array
     */
    public function getRbacNav($id){
        $roleMap=array();
        $roleIds=is_array($id)?$id:explode(",",$id);
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'id' => $roleIds,
            'field' => "id,name",
        );
        $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->getDataById($paramsObj);
        if ($checkResult["error_no"] == 0) {
            $rbacRoleResult=$checkResult["result"];
            if($rbacRoleResult){
                $roleMap=array_column($rbacRoleResult,"name","id");
            }
        }
        return $roleMap;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}