
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for `rbac_access`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}rbac_access` (
  `role_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户权限存储表';

-- ----------------------------
-- Table structure for `rbac_admin`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}rbac_admin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `account` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '账号',
  `pwd` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '密码',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '角色ID',
  `salt` varchar(10) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '密码盐',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态：1 开启，0 禁用',
  `is_supper` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否是超管',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `account` (`account`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='管理员';

-- ----------------------------
-- Table structure for `rbac_node`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}rbac_node` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '权限名称',
  `nav_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航菜单ID',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示：1 显示 0 隐藏',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `right` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '权限集合',
  `route` varchar(255) NOT NULL DEFAULT '' COMMENT '路由地址',
  `plugins` varchar(100) NOT NULL DEFAULT '' COMMENT '插件名',
  `old_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '旧ID',
  `right_index` varchar(100) NOT NULL DEFAULT '' COMMENT '权限索引',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='权限节点表';

-- ----------------------------
-- Table structure for `rbac_nav`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}rbac_nav` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '菜单名称',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示：1 显示 0 隐藏',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `icon` varchar(100) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '图标',
  `isTop` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '置顶',
  `plugins` varchar(100) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '插件目录',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='菜单导航';

-- ----------------------------
-- Table structure for `rbac_permission_code`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}rbac_permission_code` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '目录地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示',
  `plugins` varchar(100) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '插件',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for `rbac_role`
-- ----------------------------
CREATE TABLE IF NOT EXISTS `{table_pre}rbac_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '角色名称',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示：1 显示 0 隐藏',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='角色表';

SET FOREIGN_KEY_CHECKS = 1;

