<?php

namespace plugins\ltcms_backend_account;

class config
{
    //返回插件基本信息
    static function info()
    {
        $info = [
            "id" => self::installInfo("id",0),
            "goodId" => self::installInfo("goodId",0),
            "name" => self::installInfo("name","后台-账号"),
            "version" => "1.0",
            "status" => 0,   //插件状态 1启动,其他停止
            "setUpView" => [   //设置视图 需要配置有setUpView 方法
                "enable" => 0,          //是否显示,1显示 2不显示
                "width" => 660,             //设置窗口宽度
                "height" => 500             //设置窗口高度
            ],
            "description" => "后台-账号",
        ];
        return $info;
    }

    /**
     * 获取安装信息
     * @param $name
     * @param string $default
     * @return array|mixed|null|string
     */
    static function installInfo($name, $default = "")
    {
        $dirPath=__DIR__;
        $path = $dirPath . "/info.json";
        if (is_file($path)) {
            $str = file_get_contents($path);
            $jsonArr = toJsonDecode($str);
            return array_path($jsonArr, $name, $default);
        }
        return $default;
    }

    /**
     * 数据初始化
     */
    static function init()
    {
        // 检查常量是否已定义 兼容版本
        if (!defined('LTCMS_ROUTE_PREFIX')) {
            // 如果常量不存在，创建并赋值为空字符串
            define('LTCMS_ROUTE_PREFIX', '');
        }
        loadPluginResource("ltcms_backend_account");
        return ["error_no" => 0, "error_msg" => ""];
    }

    /**
     * 安装脚本
     * @return array
     */
    public function install(){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $this->init();
        }
        if ($final_arr["error_no"] == 0) {
            //安装数据库
            $checkResult=app("LtcmsBackendAccount_L_install")->database();
            if($checkResult["error_no"]==0){

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //创建后台菜单
            $checkResult=app("LtcmsBackendAccount_L_install")->menu();
            if($checkResult["error_no"]==0){

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //移动静态资源
            $checkResult=app("LtcmsBackendAccount_L_install")->moveRes();
            if($checkResult["error_no"]==0){

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    //插件卸载通知事件 不用返回信息
    public function uninstall()
    {
        //移除后台菜单
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "plugins"=>"ltcms_backend_account",
        );
        app("S_Admin_adminFunc")->deletePlugins($paramsObj);
        //移除资源
        app("LtcmsBackendAccount_L_install")->removeRes();
    }

    //设置节目
    public function setUpView()
    {
        //个人设置界面
//        $data = array();
//        return view("index", $data);
    }
}




