<?php

namespace plugins\ltcms_backend_account\client\admin;

class C_rbac_admin
{
    /**
     * 同步数据
     * @param string $paramObj
     */
    public function syncAccount($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->syncAccount($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 详情信息
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 详情信息
     * @param string $paramObj
     */
    public function infoByAccount($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->infoByAccount($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->update($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->store($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更改密码
     * @param string $paramObj
     */
    public function changePwd($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->changePwd($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 初始化账号
     * @param string $paramObj
     */
    public function initAccount($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->initAccount($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更改自己的密码
     * @param string $paramObj
     */
    public function changeSelfPwdExec($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "id"=>app("LtcmsBackendAccount_L_Admin_login")->getLoginData()["id"],
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->changePwd($paramsObj);
        if($checkResult["error_no"]==0){
            //删除登录信息
            app("LtcmsBackendAccount_L_Admin_login")->logout();
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 获取列表
     * @param string $paramObj
     */
    public function listData($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_Admin_rbacAdmin")->listData($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_S_Admin_rbacAdmin")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}