<?php

namespace plugins\ltcms_backend_account\client;

use plugins\ltcms_backend_account\config;

class C_Install
{
    /**
     * 安装数据库
     * @param string $paramObj
     */
    public function database($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_install")->database($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 后台菜单
     * @param string $paramObj
     */
    public function menu($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("LtcmsBackendAccount_L_install")->menu($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 安装插件
     * @param string $paramObj
     */
    public function install($paramObj=""){
        $config=new config();
        $checkResult=$config->install();
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 卸载插件
     * @param string $paramObj
     */
    public function uninstall($paramObj=""){
        $config=new config();
        $config->uninstall();
        return apiResult(true,"success",0);
    }
}