<?php

$pluginDir="ltcms_backend_account";
$pluginsPath = "plugins/{$pluginDir}";

router()->group("", function () use ($pluginDir,$pluginsPath){

    //rbac 菜单
    router()->get("{$pluginDir}/rbacNav", "{$pluginsPath}/admin/controller/Rbac_nav/index");  //列表数据
    router()->get("{$pluginDir}/rbacNav/create", "{$pluginsPath}/admin/controller/Rbac_nav/create"); //添加
    router()->get("{$pluginDir}/rbacNav/edit", "{$pluginsPath}/admin/controller/Rbac_nav/edit"); //修改
    router()->post("{$pluginDir}/rbacNav", "{$pluginsPath}/admin/controller/Rbac_nav/store"); //添加[接口]
    router()->put("{$pluginDir}/rbacNav", "{$pluginsPath}/admin/controller/Rbac_nav/update"); //修改[接口]
    router()->delete("{$pluginDir}/rbacNav", "{$pluginsPath}/admin/controller/Rbac_nav/delete"); //删除[接口]

    //rbac 角色
    router()->get("{$pluginDir}/rbacRole", "{$pluginsPath}/admin/controller/Rbac_role/index");  //列表数据
    router()->get("{$pluginDir}/rbacRole/create", "{$pluginsPath}/admin/controller/Rbac_role/create"); //添加
    router()->get("{$pluginDir}/rbacRole/edit", "{$pluginsPath}/admin/controller/Rbac_role/edit"); //修改
    router()->post("{$pluginDir}/rbacRole", "{$pluginsPath}/admin/controller/Rbac_role/store"); //添加[接口]
    router()->put("{$pluginDir}/rbacRole", "{$pluginsPath}/admin/controller/Rbac_role/update"); //修改[接口]
    router()->delete("{$pluginDir}/rbacRole", "{$pluginsPath}/admin/controller/Rbac_role/delete"); //删除[接口]

    //rbac 节点
    router()->get("{$pluginDir}/rbacNode/export", "{$pluginsPath}/admin/controller/Rbac_node/export");  //导出
    router()->post("{$pluginDir}/rbacNode/export", "{$pluginsPath}/admin/controller/Rbac_node/exportExec");  //导出接口
    router()->get("{$pluginDir}/rbacNode", "{$pluginsPath}/admin/controller/Rbac_node/index");  //列表数据
    router()->get("{$pluginDir}/rbacNode/create", "{$pluginsPath}/admin/controller/Rbac_node/create"); //添加
    router()->get("{$pluginDir}/rbacNode/edit", "{$pluginsPath}/admin/controller/Rbac_node/edit"); //修改
    router()->post("{$pluginDir}/rbacNode", "{$pluginsPath}/admin/controller/Rbac_node/store"); //添加[接口]
    router()->put("{$pluginDir}/rbacNode", "{$pluginsPath}/admin/controller/Rbac_node/update"); //修改[接口]
    router()->delete("{$pluginDir}/rbacNode", "{$pluginsPath}/admin/controller/Rbac_node/delete"); //删除[接口]
    router()->post("{$pluginDir}/rbacNode/copy", "{$pluginsPath}/admin/controller/Rbac_node/copy"); //复制

    //rbac 管理员
    router()->get("{$pluginDir}/rbacAdmin/initNode", "{$pluginsPath}/admin/controller/Rbac_admin/initNode");  //初始化节点
    router()->get("{$pluginDir}/rbacAdmin/syncAccount", "{$pluginsPath}/admin/controller/Rbac_admin/syncAccount");  //同步账号
    router()->get("{$pluginDir}/rbacAdmin", "{$pluginsPath}/admin/controller/Rbac_admin/index");  //列表数据
    router()->get("{$pluginDir}/rbacAdmin/changePwd", "{$pluginsPath}/admin/controller/Rbac_admin/changePwd"); //更改密码
    router()->get("{$pluginDir}/rbacAdmin/changeSelfPwd", "{$pluginsPath}/admin/controller/Rbac_admin/changeSelfPwd"); //更改自己的密码
    router()->get("{$pluginDir}/rbacAdmin/create", "{$pluginsPath}/admin/controller/Rbac_admin/create"); //添加
    router()->get("{$pluginDir}/rbacAdmin/edit", "{$pluginsPath}/admin/controller/Rbac_admin/edit"); //修改
    router()->post("{$pluginDir}/rbacAdmin", "{$pluginsPath}/admin/controller/Rbac_admin/store"); //添加[接口]
    router()->put("{$pluginDir}/rbacAdmin/changePwd", "{$pluginsPath}/admin/controller/Rbac_admin/changePwdExec"); //更改密码[接口]
    router()->put("{$pluginDir}/rbacAdmin/changeSelfPwd", "{$pluginsPath}/admin/controller/Rbac_admin/changeSelfPwdExec"); //更改自己的密码[接口]
    router()->put("{$pluginDir}/rbacAdmin", "{$pluginsPath}/admin/controller/Rbac_admin/update"); //修改[接口]
    router()->delete("{$pluginDir}/rbacAdmin", "{$pluginsPath}/admin/controller/Rbac_admin/delete"); //删除[接口]

    //权限码
    router()->get("{$pluginDir}/permissionCode/action", "{$pluginsPath}/admin/controller/Permission_code/listAction");  //方法列表
    router()->get("{$pluginDir}/permissionCode/controller", "{$pluginsPath}/admin/controller/Permission_code/listController");  //控制器列表
    router()->get("{$pluginDir}/permissionCode", "{$pluginsPath}/admin/controller/Permission_code/index");  //列表数据
    router()->get("{$pluginDir}/permissionCode/create", "{$pluginsPath}/admin/controller/Permission_code/create"); //添加
    router()->get("{$pluginDir}/permissionCode/edit", "{$pluginsPath}/admin/controller/Permission_code/edit"); //修改
    router()->post("{$pluginDir}/permissionCode", "{$pluginsPath}/admin/controller/Permission_code/store"); //添加[接口]
    router()->put("{$pluginDir}/permissionCode", "{$pluginsPath}/admin/controller/Permission_code/update"); //修改[接口]
    router()->delete("{$pluginDir}/permissionCode", "{$pluginsPath}/admin/controller/Permission_code/delete"); //删除[接口]

})->middleware(["isAdminAuth", "isAdminLogin"]);


