<?php

namespace plugins\ltcms_backend_account\admin\controller;

use plugins\ltcms_backend_account\controller\Base;

class Rbac_role extends Base
{
    /**
     * 数据列表
     * @return mixed
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = app("LtcmsBackendAccount_C_Admin_rbacRole")->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/rbac_role/index", $data)->templatePath($this->templatePath);
    }

    /**
     * 添加
     * @return mixed
     */
    public function create()
    {
        $permissionList=app("LtcmsBackendAccount_C_Admin_rbac")->permissionList();
        $data = array();
        $data["permissionList"]=$permissionList;
        $data["request"] = request()->param();
        return view("admin/rbac_role/create", $data)->templatePath($this->templatePath);
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacRole")->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  编辑
     * @show 2
     */
    public function edit()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacRole")->info();
        $rowData=array();
        $nodeId=array();
        if ($result["success"]) {
            $rowData = $result["data"];
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "role_id"=>$rowData["id"],
            );
            $result = app("LtcmsBackendAccount_C_Admin_rbacAccess")->getData($paramsObj);
            if ($result["success"]) {
                if($result["data"]){
                    $nodeId = array_column($result["data"],"node_id");
                }
            }
        }
        $permissionList=app("LtcmsBackendAccount_C_Admin_rbac")->permissionList();
        $data = array();
        $data["rowData"] = $rowData;
        $data["permissionList"]=$permissionList;
        $data["nodeId"]=$nodeId;
        $data["request"] = request()->param();
        return view("admin/rbac_role/edit", $data)->templatePath($this->templatePath);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacRole")->update();
        return jsonResponse($result);
    }

    /**
     * 删除资源
     */
    public function delete()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacRole")->delete();
        return jsonResponse($result);
    }
}