<?php

namespace plugins\ltcms_backend_account\admin\controller;

use plugins\ltcms_backend_account\controller\Base;

class Rbac_node extends Base
{
    /**
     * 数据列表
     * @return mixed
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = app("LtcmsBackendAccount_C_Admin_rbacNode")->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/rbac_node/index", $data)->templatePath($this->templatePath);
    }

    /**
     * 导出数据
     * @return mixed
     */
    public function export()
    {
        $permissionList=app("LtcmsBackendAccount_C_Admin_rbac")->permissionList();
        $data = array();
        $data["permissionList"]=$permissionList;
        $data["request"] = request()->param();
        return view("admin/rbac_node/export", $data)->templatePath($this->templatePath);
    }

    /**
     * 创建资源[执行]
     */
    public function exportExec()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacNode")->export();
        return jsonResponse($result);
    }

    /**
     * 添加
     * @return mixed
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/rbac_node/create", $data)->templatePath($this->templatePath);
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacNode")->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  编辑
     * @show 2
     */
    public function edit()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacNode")->info();
        $rowData=array();
        if ($result["success"]) {
            $rowData = $result["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/rbac_node/edit", $data)->templatePath($this->templatePath);
    }

    /**
     * 复制资源
     */
    public function copy()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacNode")->copy();
        return jsonResponse($result);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacNode")->update();
        return jsonResponse($result);
    }

    /**
     * 删除资源
     */
    public function delete()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacNode")->delete();
        return jsonResponse($result);
    }
}