<?php

namespace plugins\ltcms_backend_account\admin\controller;

use plugins\ltcms_backend_account\controller\Base;

class Rbac_admin extends Base
{
    /**
     * 数据列表
     * @return mixed
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/rbac_admin/index", $data)->templatePath($this->templatePath);
    }

    /**
     * 添加
     * @return mixed
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/rbac_admin/create", $data)->templatePath($this->templatePath);
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->store();
        return jsonResponse($result);
    }

    /**
     * 同步账号
     */
    public function syncAccount()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->syncAccount();
        return jsonResponse($result);
    }

    /**
     * 初始化节点
     */
    public function initNode()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbac")->initNode();
        return jsonResponse($result);
    }

    /**
     * 初始化数据
     */
    public function initData()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbac")->initData();
        return jsonResponse($result);
    }

    /**
     * @actionName  编辑
     * @show 2
     */
    public function edit()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->info();
        $rowData=array();
        if ($result["success"]) {
            $rowData = $result["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/rbac_admin/edit", $data)->templatePath($this->templatePath);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  更改密码
     * @show 2
     */
    public function changePwd()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->info();
        $rowData=array();
        if ($result["success"]) {
            $rowData = $result["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/rbac_admin/changePwd", $data)->templatePath($this->templatePath);
    }

    /**
     * 更改密码
     */
    public function changePwdExec()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->changePwd();
        return jsonResponse($result);
    }

    /**
     * @actionName  更改密码
     * @show 2
     */
    public function changeSelfPwd()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/rbac_admin/changeSelfPwd", $data)->templatePath($this->templatePath);
    }

    /**
     * 更改密码
     */
    public function changeSelfPwdExec()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->changeSelfPwdExec();
        return jsonResponse($result);
    }

    /**
     * 初始化账号
     */
    public function initAccount()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->initAccount();
        return jsonResponse($result);
    }

    /**
     * 删除资源
     */
    public function delete()
    {
        $result = app("LtcmsBackendAccount_C_Admin_rbacAdmin")->delete();
        return jsonResponse($result);
    }
}