<?php

namespace ltcms\lib;

class Data
{
    /**
     * 数据存取
     * @var array
     */
    public $data=array();

    /**
     * 获取数据参数 为空则获取所有数据
     */
    public function get($name = null, $default = null)
    {
        // 无参数时获取所有
        if (empty($name)) {
            return $this->data;
        }
        if (false === strpos($name, '.')) {
            return $this->pull($name);
        }

        $name    = explode('.', $name);
        $name[0] = strtolower($name[0]);
        $data  = $this->data;

        // 按.拆分成多维数组进行判断
        foreach ($name as $val) {
            if (isset($data[$val])) {
                $data = $data[$val];
            } else {
                return $default;
            }
        }
        return $data;
    }

    /**
     * 检测配置是否存在
     * @access public
     * @param  string $name 配置参数名（支持多级配置 .号分割）
     * @return bool
     */
    public function has($name)
    {
        if (false === strpos($name, '.') && !isset($this->data[strtolower($name)])) {
            return false;
        }
        return !is_null($this->get($name));
    }

    /**
     * 获取一级数据
     * @param  string $name 一级数据名
     * @return array
     */
    protected function pull($name)
    {
        $name = strtolower($name);
        return $this->data[$name] ?? [];
    }

    /**
     * 设置配置参数 name为数组则为批量设置
     * @access public
     * @param  array  $data 配置参数
     * @param  string $name 配置名
     * @return array
     */
    public function set($data, $name = null)
    {
        if(is_string($data)){
            $data=getMap($data,$name);
            $result = arrFusion($this->data, array_change_key_case($data));
            $this->data =$result;
        }else{
            if (!empty($name)) {
                if (isset($this->data[$name])) {
                    $result=array_merge($this->data[$name],$data);
                } else {
                    $result = $data;
                }
                $this->data[$name] = $result;
            } else {
                $result = array_merge($this->data, array_change_key_case($data));
                $this->data =$result;
            }
        }
        return $result;
    }
}