<?php

namespace app\utils\base\helper;

class Ltcms_format
{
    /**
     * 权限展示
     */
    public static function showPermissionList($data,$id=array(),$level="1")
    {
        $html="";
        $preNavChecked="";
        foreach($data  as $val){
            $navChecked="";
            $html.=<<<EOF
            <div class="child" style="margin-top:10px;" >
            <div class="box" >
EOF;
            $prefix=str_repeat("&nbsp;&nbsp;&nbsp;",$level-1);
            $html.=<<<EOF
                <div class="nav" >
                    {$prefix}
                    <input style="height:auto !important" name="nav[]" class="fileCheck1" @navChecked@ type="checkbox" value="{$val['id']}" />
                    <span>{$val["name"]}</span>
                </div>
EOF;
            if($val["child"]){
                $children=self::showPermissionList($val["child"],$id,$level+1);
                $html=str_replace("@navChecked@",$children["preNavChecked"],$html);
                $html.=$children["html"];
                $preNavChecked=$children["preNavChecked"];
            }else{
                if($val["data"]){
                    $html.=<<<EOF
                    <div class="child" style="margin-top:10px;"  >
                    <div class="box" >
EOF;
                    $prefix=str_repeat("&nbsp;&nbsp;&nbsp;",$level);
                    foreach($val["data"] as $node){
                        $html.=<<<EOF
                        <div class="node_line" >
                        {$prefix}
                        <input style="height:auto !important" class="fileAll" type="checkbox" />
                        <span>全选</span>
EOF;
                        foreach($node as $node_val){
                            $checked="";
                            if($id && in_array($node_val["id"],$id)){
                                $checked="checked";
                                $navChecked="checked";
                                $preNavChecked="checked";
                            }
                            $html.=<<<EOF
                            <input style="height:auto !important" class="fileCheck1" type="checkbox" name="node[]" value="{$node_val['id']}" {$checked} />
                            <span>{$node_val['name']}</span>
EOF;
                        }
                        $html.=<<<EOF
                        </div>
EOF;
                    }
                    $html=str_replace("@navChecked@",$navChecked,$html);
                    $html.=<<<EOF
                    </div>
                    </div>
EOF;
                }
            }
            $html.=<<<EOF
            </div>
            </div>
EOF;
        }

        if($level=="1"){
            return $html;
        }else{
            $return=array();
            $return["html"]=$html;
            $return["preNavChecked"]=$preNavChecked;
            return $return;
        }
    }

    /**
     * 进度
     */
    public static function progress($currentSize,$allSize)
    {
        $data="0%";
        if($currentSize){
            if(($currentSize +1)==$allSize){
                $data="100%";
            }else{
                $data=(intval(($currentSize/$allSize) * 10000)/100)."%";
            }
        }
        return $data;
    }

    /**
     * 字节
     */
    public static function byte($bytes)
    {
        $si_prefix = array( 'B', 'KB', 'MB', 'GB', 'TB', 'EB', 'ZB', 'YB' );
        $base = 1024;
        $index = min((int)log($bytes , $base) , count($si_prefix) - 1);
        $data=sprintf('%1.2f' , $bytes / pow($base,$index)) . ' ' . $si_prefix[$index];
        return $data;
    }

    /**
     * 时间(秒)
     */
    public static function timeSecond($second)
    {
        $si_prefix = array( '秒', '分钟', '小时', '天', '月', '年');
        $result="";

        if($second >= "31536000"){
            //年
            $base = 31536000;
            $index=5;
            $nums = floor($second / $base);
            $result.= $nums . ' ' . $si_prefix[$index]." ";
            $second = $second % $base;
        }
        if($second >= "2592000"){
            //月
            $base = 2592000;
            $index=4;
            $nums = floor($second / $base);
            $result.= $nums . ' ' . $si_prefix[$index]." ";
            $second = $second % $base;
        }
        if($second >= "86400"){
            //天
            $base = 86400;
            $index=3;
            $nums = floor($second / $base);
            $result.= $nums . ' ' . $si_prefix[$index]." ";
            $second = $second % $base;
        }
        if($second >= "3600"){
            //小时
            $base = 3600;
            $index=2;
            $nums = floor($second / $base);
            $result.= $nums . ' ' . $si_prefix[$index]." ";
            $second = $second % $base;
        }
        if($second >= "60"){
            //分钟
            $base = 60;
            $index=1;
            $nums = floor($second / $base);
            $result.= $nums . ' ' . $si_prefix[$index]." ";
            $second = $second % $base;
        }
        if($second >0){
            //秒
            $index=0;
            $result.= $second . ' ' . $si_prefix[$index]." ";
        }
        return $result;
    }

    /**
     * 分类-递归数组
     */
    public static function recursionArr($data,$pid=0)
    {
        $return=array();
        if($data){
            if($pid=="0"){
                $temp=array();
                foreach($data as $val){
                    $temp[$val["pid"]][]=$val;
                }
                $data=$temp;
            }
            $return=isset($data[$pid])?$data[$pid]:array();
            if($return){
                foreach($return as $key=>$val){
                    if(isset($data[$val["id"]]) && $data[$val["id"]]){
                        $return[$key]["child"]=self::recursionArr($data,$val["id"]);
                    }else{
                        $return[$key]["child"]=array();
                    }
                }
            }
        }
        return $return;
    }

    /**
     * 模型数据融合
     */
    public static function modelDataMerge($infoData,$data)
    {
        $data=array_filter($data,function ($item){
            return !is_null($item);
        });
        return array_merge($infoData,$data);
    }

    /**
     * 模型数据
     */
    public static function modelData($fields,$data,$mergeData=array())
    {
        $return=array();
        foreach($fields as $key=>$val){
            if(isset($data->$key)){
                $type=$val["type"];
                if($type=="int"){
                    $return[$key]=intval($data->$key);
                }else{
                    $return[$key]=is_array($data->$key)?toJsonEncode($data->$key):$data->$key;
                }
            }
        }
        return $return;
    }

    /**
     * 递归数据转换成html
     */
    public static function recursionTohtml($data,$selectId="-1",$level=0)
    {
        $str="";
        $pre=($level==0)?"|— ":str_repeat("&nbsp;&nbsp;&nbsp;",$level)."|— ";
        foreach($data as $key=>$val){
            $checked="";
            if($selectId==$val["id"]){
                $checked="selected";
            }
            $str.="<option value='".$val["id"]."' {$checked} >{$pre}{$val["name"]}</option>";
            if($val["child"]){
                $str.=self::recursionTohtml($val["child"],$selectId,$level+1);
            }
        }
        return $str;
    }

    /**
     * 递归数据转换成 multi html
     */
    public static function recursionToMultihtml($data,$selectMap,$fieldIndexName=array(),$level=0)
    {
        $selectId=(isset($selectMap["id"]) && $selectMap["id"])?$selectMap["id"]:0;
        $parent=(isset($selectMap["data"]) && $selectMap["data"])?$selectMap["data"]:array();
        $isFind=0;
        $str="<div class='categoryBox'>";
        $count=count($data) -1;
        foreach($data as $key=>$val){
            if($key=="0"){
                if(isset($val['fieldIndex'])){
                    $fieldIndex=isset($fieldIndexName[$val['fieldIndex']])?$fieldIndexName[$val['fieldIndex']]:"xxx";
                }else{
                    $fieldIndex="xxx";
                }
                $str.="<div class='categoryNav'>";
                $str.="<div class='label'>{$fieldIndex}:&nbsp;&nbsp;</div>";
                $str.="<div class='con'>";
            }
            if($val["id"]==$selectId){
                $isFind=1;
                $str.="<span data-id='{$val["id"]}' class='hand active' >{$val["name"]}</span>";
            }else{
                if($parent && in_array($val["id"],$parent)){
                    $str.="<span data-id='{$val["id"]}' class='hand active' >{$val["name"]}</span>";
                }else{
                    $str.="<span data-id='{$val["id"]}' class='hand' >{$val["name"]}</span>";
                }
            }
            if($key==$count){
                $str.="</div>";
                $str.="</div>";
            }
        }
        foreach($data as $key=>$val){
            if($parent){
                if(in_array($val["id"],$parent)){
                    $str.="<div class='categoryCon' >";
                }else{
                    $str.="<div class='categoryCon' style='display: none;'>";
                }
            }else{
                if($key=="0"){
                    $str.="<div class='categoryCon' >";
                }else{
                    $str.="<div class='categoryCon' style='display: none;'>";
                }
            }
            if($val["child"]){
                if($isFind){
                    $selectMap=array();
                }
                $str.=self::recursionToMultihtml($val["child"],$selectMap,$fieldIndexName,$level);
            }
            $str.="</div>";
        }
        $str.="</div>";
        return $str;
    }

    /**
     * 分类-递归-获取子元素数据
     */
    public static function getChildValByRe($data,$id,$level=0)
    {
        $return=array();
        if($data){
            if($level=="0"){
                $temp=array();
                foreach($data as $val){
                    $temp[$val["pid"]][]=$val;
                    if($id==$val["id"]){
                        $return[]=$val;
                    }
                }
                $data=$temp;
            }
            $childArr=isset($data[$id])?$data[$id]:array();
            $return=array_merge($return,$childArr);
            if($return){
                foreach($return as $key=>$val){
                    if(isset($data[$val["id"]]) && $data[$val["id"]]){
                        $return=array_merge($return,self::getChildValByRe($data,$val["id"],$level+1));
                    }
                }
            }
        }
        return $return;
    }

    /**
     * 分类-递归-获取父元素数据
     */
    public static function getParentValByRe($data,$id)
    {
        $return=array();
        if($data){
            foreach($data as $val){
                if($val["id"]==$id){
                    $return[]=$val;
                    if($val["pid"]){
                        $return=array_merge($return,self::getParentValByRe($data,$val["pid"]));
                    }
                }
            }
        }
        return $return;
    }

    /**
     * 文件/目录数据处理
     */
    public static function fileHandle($packDir)
    {
        $files=glob($packDir."/*");
        $return=array();
        foreach($files as $file){
            $tmp=array();
            $tmp["file"]=trim(str_replace($packDir,"",$file),"/");
            $tmp["filePath"]=$file;
            if(is_dir($file)){
                $tmp["type"]=1; //目录
            }else{
                $tmp["type"]=2; //文件
            }
            $return[]=$tmp;
        }
        return $return;
    }

    /**
     * 目录展示
     */
    public static function showDir($fileList,$resourceDir,$header="",$level="1",$isCheck="1")
    {
        $html="";
        if($header){
            $html.="<ul>";
//            $html.="<li><div style='width: 800px;display: inline-block;'>文件名称</div></li>";
        }else{
            $html.="<div class='child'>";
        }
        foreach($fileList as $key=>$file){
            if(is_dir($file)){
                $img='<img style="width:15px;"  src="'.$resourceDir.'/img/folder.png">';
                $class='class="nextFileList"';
            }else{
                $img='<img style="width:15px;"  src="'.$resourceDir.'/img/file.png">';
                $class="";
            }
            $checked=$isCheck?"checked":"";
            $html.='<div class="box">';
            $html.='<li>';
            $html.='<div style="width: 800px;display: inline-block;">';
            $html.=str_repeat("&nbsp;&nbsp;",$level).'<input class="fileCheck" type="checkbox" name="packageConfig[]" '.$checked.' value="'.$file.'" />';
            $html.='<span '.$class.' data-open="0" data-file="'.$file.'" data-index="'.$level.'" style="cursor: pointer;" >'.$img.basename($file).'</span>';
            $html.='</div>';
            $html.='</li>';
            $html.='</div>';
        }
        if($header){
            $html.="</ul>";
        }else{
            $html.="</div>";
        }
        return $html;
    }

    /**
     * 目录展示
     */
    public static function showDirByData($fileList,$resourceDir,$header="",$level=1)
    {
        $html="";
        if($header){
            $html.="<ul>";
//            $html.="<li><div style='width: 800px;display: inline-block;'>文件名称</div></li>";
        }else{
            $html.="<div class='child'>";
        }
        foreach($fileList as $val){
            $checked=$val["checked"]?"checked":"";
            $isLoad="0";
            if(is_dir($val["file"])){
                $img='<img style="width:15px;"  src="'.$resourceDir.'/img/folder.png">';
                if(isset($val["child"]) && $val["child"]){
                    $class='class="openFiles"';
                    $isLoad="1";
                }else{
                    $class='class="nextFileList"';
                }
            }else{
                $img='<img style="width:15px;"  src="'.$resourceDir.'/img/file.png">';
                $class="";
            }

            $html.='<div class="box">';
            $html.='<li>';
            $html.='<div style="width: 800px;display: inline-block;">';
            $html.=str_repeat("&nbsp;&nbsp;",$level).'<input class="fileCheck" type="checkbox" name="packageConfig[]" '.$checked.' value="'.$val["file"].'" />';
            $html.='<span '.$class.' isLoad="'.$isLoad.'" data-open="1" data-file="'.$val["file"].'" data-index="'.$level.'" style="cursor: pointer;" >'.$img.basename($val["file"]).'</span>';
            $html.='</div>';
            $html.='</li>';
            if(isset($val["child"]) && $val["child"]){
                $html.=self::showDirByData($val["child"],$resourceDir,0,$level+1);
            }
            $html.='</div>';
        }
        if($header){
            $html.="</ul>";
        }else{
            $html.="</div>";
        }
        return $html;
    }
}