<?php

namespace app\middleware;

use \ltcms\middleware\Middleware_contract;

class CheckLogin implements Middleware_contract
{
    /**
     *  处理请求
     */
    public function handle($request, \Closure $next)
    {
        //判断登录请求
        $loginData=app("P_BackendAccount")->getLoginData();
        if (!$loginData["status"]) {
            if(request()->isAjax()){
                $response=apiResult(false,lang("admin.pleaseLogin"),app("errorCode")::AUTH_ENTICATION);
                return jsonResponse($response);
            }else{
                header("content-type:text/html;charset=utf-8");
                echo getScriptContent(LTCMS_ROUTE_PREFIX."/login");
                exit;
            }
        }
        $response = $next($request);
        return $response;
    }
}


