<?php

namespace app\logic\admin;

class L_module
{
    /**
     * 补充路由
     * @param string $paramObj
     */
    public function supplyRoute($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->request->id,
                "field"=>"id,name",
            );
            $checkResult=app("S_Admin_module")->allData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if($result){
                    foreach($result as $val){
                        //检测菜单是否存在
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "pid"=>1,
                            "name"=>$val["name"]."管理",
                            "verify"=>0,
                            "field"=>"id",
                        );
                        $checkResult=app("S_Admin_adminMenu")->infoByUnique($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $menuResult=$checkResult["result"];
                            if(!$menuResult){
                                //模块添加路由
                                addRouteModule($val['id']);
                                //更新设置
                                upSettingCache($val['id']);
                            }
                        }
                    }
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  创建权限节点数据
     * @param string $paramObj
     */
    public function createNode($paramObj="")
    {
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取模块文章数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "module"=>"article",
            );
            $checkResult=app("S_Admin_module")->allData($paramsObj);
            if($checkResult["error_no"]==0){
                $moduleResult=$checkResult["result"];
                if($moduleResult){
                    foreach($moduleResult as $module){
                        if ($final_arr["error_no"] == 0) {
                            //添加菜单
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$module["id"],
                            );
                            $checkResult=$this->createModuleNode($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  创建模型权限节点数据
     * @param string $paramObj
     */
    public function createModuleNode($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取模块文章数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->request->id,
                "field"=>"id,name,module",
            );
            $checkResult=app("S_Admin_module")->info($paramsObj);
            if($checkResult["error_no"]==0){
                $moduleResult=$checkResult["result"];
                if($moduleResult){
                    //添加菜单
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "name"=>$moduleResult["name"]."管理",
                        "icon"=>"icon-tuozhan",
                        "is_show"=>"1",
                        "isTop"=>"1",
                        "sort"=>"120",
                        "plugins"=>"ltmcs@module_{$moduleResult["id"]}",
                    );
                    $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->record($paramsObj);
                    if($checkResult["error_no"]==0){
                        $navResult=$checkResult["result"];
                        if($moduleResult["module"]=="article"){
                            $moduleNodes=$this->getModuleNodes($moduleResult,$navResult["id"]);
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "data"=>$moduleNodes,
                            );
                            $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->storeBatch($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  更新模型权限节点数据
     * @param string $paramObj
     */
    public function updateModuleNode($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取模块文章数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->request->id,
                "field"=>"id,name,module",
            );
            $checkResult=app("S_Admin_module")->info($paramsObj);
            if($checkResult["error_no"]==0){
                $moduleResult=$checkResult["result"];
                if($moduleResult){
                    if($moduleResult["module"]=="article"){
                        if ($final_arr["error_no"] == 0) {
                            Db()->startTrans();
                            $dataObj->data->use_trans = true;
                        }
                        if ($final_arr["error_no"] == 0) {
                            //更新菜单数据
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "plugins"=>"ltmcs@module_".$moduleResult["id"],
                                "name"=>$moduleResult["name"]."管理",
                            );
                            $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNav")->updateData($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //更新节点数据
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>$moduleResult["name"]."列表",
                                'route' => "article?moduleId={$moduleResult["id"]}",
                                "plugins"=>"ltmcs@module_article_{$moduleResult["id"]}",
                            );
                            $checkResult=app("LtcmsBackendAccount_L_Admin_rbacNode")->updateData($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($dataObj->data->use_trans) {
                            if ($final_arr["error_no"] == 0) {
                                Db()->commitTrans();
                            } else {
                                Db()->rollbackTrans();
                            }
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     *  删除菜单数据
     * @param string $paramObj
     */
    public function deleteModuleData($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($final_arr["error_no"] == 0) {
                Db()->startTrans();
                $dataObj->data->use_trans = true;
            }
            if ($final_arr["error_no"] == 0) {
                //删除菜单数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "plugins"=>"ltmcs@module_{$dataObj->request->id}",
                );
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNav")->deleteByPlugins($paramsObj);
                if($checkResult["error_no"]==0){

                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
            if ($final_arr["error_no"] == 0) {
                //删除节点文章数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "plugins"=>"ltmcs@module_article_{$dataObj->request->id}",
                );
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->deleteByPlugins($paramsObj);
                if($checkResult["error_no"]==0){

                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
            if ($final_arr["error_no"] == 0) {
                //删除节点分类数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "plugins"=>"ltmcs@module_category_{$dataObj->request->id}",
                );
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->deleteByPlugins($paramsObj);
                if($checkResult["error_no"]==0){

                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
            if ($final_arr["error_no"] == 0) {
                //删除节点字段设置数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "plugins"=>"ltmcs@module_fields_{$dataObj->request->id}",
                );
                $checkResult=app("LtcmsBackendAccount_S_Admin_rbacNode")->deleteByPlugins($paramsObj);
                if($checkResult["error_no"]==0){

                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
            if ($dataObj->data->use_trans) {
                if ($final_arr["error_no"] == 0) {
                    Db()->commitTrans();
                } else {
                    Db()->rollbackTrans();
                }
            }
        }
        return $final_arr;
    }

    /**
     * 获取节点
     */
    public function getNode($name,$nav_id,$is_show,$sort,$route,$right_index,$right,$plugins){
        $nowTime=app("ltcmsTime")::getTime();
        return array(
            "name"=>$name,
            "nav_id"=>$nav_id,
            "create_time"=>$nowTime,
            "update_time"=>$nowTime,
            'is_show' => $is_show,
            'sort' => $sort,
            'route' => $route,
            'right_index' => $right_index,
            'right' => toJsonEncode($right),
            'plugins' => $plugins,
        );
    }

    /**
     * 获取模块节点数据
     * @param $module
     * @return array
     */
    public function getModuleNodes($module,$nav_id){
        $nodes=array();

        /**
         * 文章数据
         */
        $plugins="ltmcs@module_article_{$module["id"]}";
        $nodes[]=$this->getNode($module["name"]."列表",$nav_id,1,10,"article?moduleId={$module["id"]}","文章",array(
            'app\admin\controller\Article@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","文章",array(
            'app\admin\controller\Article@create',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","文章",array(
            'app\admin\controller\Article@edit',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","文章",array(
            'app\admin\controller\Article@setRecycle',
            'app\admin\controller\Article@delete',
        ),$plugins);
        $nodes[]=$this->getNode("模块设置",$nav_id,1,30,"article/setting?moduleId={$module["id"]}","文章",array(
            'app\admin\controller\Article@setting',
            'app\admin\controller\Article@recordBatch',
        ),$plugins);
        $nodes[]=$this->getNode("回收站",$nav_id,1,20,"article/indexRecycle?moduleId={$module["id"]}","文章",array(
            'app\admin\controller\Article@indexRecycle',
        ),$plugins);

        /**
         * 字段数据
         */
        $plugins="ltmcs@module_fields_{$module["id"]}";
        $nodes[]=$this->getNode("字段设置",$nav_id,1,40,"fields?moduleId={$module["id"]}","文章字段",array(
            'app\admin\controller\Fields@index',
            'app\admin\controller\Fields@use_explain',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","文章字段",array(
            'app\admin\controller\Fields@create',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","文章字段",array(
            'app\admin\controller\Fields@edit',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","文章字段",array(
            'app\admin\controller\Fields@delete',
        ),$plugins);

        /**
         * 分类数据
         */
        $plugins="ltmcs@module_category_{$module["id"]}";
        $nodes[]=$this->getNode("分类列表",$nav_id,1,50,"category?dataType=module&dataId={$module["id"]}","文章分类",array(
            'app\admin\controller\Category@index',
        ),$plugins);
        $nodes[]=$this->getNode("添加",$nav_id,0,10,"","文章分类",array(
            'app\admin\controller\Category@create',
            'app\admin\controller\Category@checkDir',
        ),$plugins);
        $nodes[]=$this->getNode("编辑",$nav_id,0,20,"","文章分类",array(
            'app\admin\controller\Category@edit',
            'app\admin\controller\Category@checkDir',
        ),$plugins);
        $nodes[]=$this->getNode("删除",$nav_id,0,30,"","文章分类",array(
            'app\admin\controller\Category@delete',
        ),$plugins);

        /**
         * 更新缓存
         */
        $plugins="ltmcs@module_cache_{$module["id"]}";
        $nodes[]=$this->getNode("更新数据",$nav_id,1,60,"cache?moduleId={$module["id"]}","文章缓存",array(
            'app\admin\controller\Cache@index',
        ),$plugins);
        $nodes[]=$this->getNode("更新信息",$nav_id,0,10,"","文章缓存",array(
            'app\admin\controller\Cache@update',
        ),$plugins);
        return $nodes;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj="")
    {
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //录入模块数据
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj=blenderObject($paramsObj,$paramObj);
            $checkResult=app("S_Admin_module")->record($paramsObj);
            if($checkResult["error_no"]==0){
                $final_arr["result"]=$checkResult["result"];
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //更新缓存
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>0,
            );
            $checkResult=app("L_Common_caches")->updateModule($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 添加路由
     * @param string $paramObj
     */
    public function routeAdd($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $id=trim($dataObj->request->id);
            $moduleData=module($id);
            $dataObj->data->moduleData=$moduleData;
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->moduleData && $dataObj->data->moduleData["module"]=="article"){
                //查询是否增加过
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'fromId' => $dataObj->data->moduleData["id"],
                    'type' => "module",
                );
                $checkResult=app("S_Admin_map_relation")->allData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    if(!$result){
                        if ($final_arr["error_no"] == 0) {
                            //增加菜单
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'pid' => 1,
                                'name' => $dataObj->data->moduleData["name"]."管理",
                                'icon' => 'icon-tuozhan',
                                'sort' => '1',
                                'status' => '1',
                            );
                            $checkResult=app("S_Admin_adminMenu")->store($paramsObj);
                            if ($checkResult["error_no"] == 0) {
                                $dataObj->data->toId=$checkResult["result"]["id"];
                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //增加对应关系
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'fromId' =>$dataObj->data->moduleData["id"],
                                'toId' => $dataObj->data->toId,
                                'type' => "module",
                            );
                            $checkResult=app("S_Admin_map_relation")->store($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //增加权限节点
                            $baseNote=array(
                                "menuId"=>$dataObj->data->toId,
                                "module"=>"admin/Article",
                                "moduleName"=>"{$dataObj->data->moduleData["name"]}管理",
                                "isEnable"=>"1",
                                "other"=>"moduleId=".$dataObj->data->moduleData["id"],
                            );
                            $roleNote=array();
                            $roleNote[]=array(
                                "route"=>"article?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"index",
                                "actionName"=>"{$dataObj->data->moduleData["name"]}列表",
                                "isShow"=>"1",
                                "sort"=>"1",
                            );
                            $roleNote[]=array(
                                "route"=>"article/indexRecycle?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"indexRecycle",
                                "actionName"=>"回收站",
                                "isShow"=>"1",
                                "sort"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article/edit",
                                "action"=>"edit",
                                "actionName"=>"编辑",
                                "isShow"=>"2",

                            );
                            $roleNote[]=array(
                                "route"=>"article/create",
                                "action"=>"create",
                                "actionName"=>"创建",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article",
                                "action"=>"delete	",
                                "actionName"=>"删除",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article/setRecycle",
                                "action"=>"setRecycle",
                                "actionName"=>"回收站",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article/setting?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"setting",
                                "actionName"=>"模块设置",
                                "isShow"=>"1",
                                "sort"=>"3",
                            );
                            $roleNote[]=array(
                                "route"=>"fields?moduleId=".$dataObj->data->moduleData["id"],
                                "module"=>"app/admin/controller/Fields",
                                "action"=>"index",
                                "actionName"=>"字段设置",
                                "isShow"=>"1",
                                "sort"=>"4",
                            );
                            $roleNote[]=array(
                                "route"=>"article/recordBatch?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"recordBatch	",
                                "actionName"=>"设置更新",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"category?dataType=module&dataId=".$dataObj->data->moduleData["id"],
                                "action"=>"index",
                                "actionName"=>"分类管理",
                                "module"=>"admin/Category",
                                "isShow"=>"1",
                                "sort"=>"3",
                                "other"=>"dataType=module&dataId=".$dataObj->data->moduleData["id"],
                            );
                            foreach($roleNote  as $nval){
                                if ($final_arr["error_no"] == 0) {
                                    $param=array_merge($baseNote,$nval);
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "menuId"=>$param["menuId"],
                                        "route"=>$param["route"],
                                        "module"=>$param["module"],
                                        "moduleName"=>$param["moduleName"],
                                        "action"=>$param["action"],
                                        "actionName"=>$param["actionName"],
                                        "isShow"=>$param["isShow"],
                                        "isEnable"=>$param["isEnable"],
                                        "other"=>$param["other"],
                                    );
                                    $checkResult=app("S_Admin_adminFunc")->store($paramsObj);
                                    if ($checkResult["error_no"] == 0) {

                                    } else {
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                                if ($final_arr["error_no"]) {
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新路由名称
     * @param string $paramObj
     */
    public function routeUpdate($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $id=trim($dataObj->request->id);
            $moduleData=module($id);
            $dataObj->data->moduleData=$moduleData;
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->moduleData && $dataObj->data->moduleData["module"]=="article"){
                //查询是否增加过
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'fromId' => $dataObj->data->moduleData["id"],
                    'type' => "module",
                );
                $checkResult=app("S_Admin_map_relation")->allData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    if($result){
                        foreach($result as $val){
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'id' => $val["toId"],
                                    'name' => $dataObj->data->moduleData["name"]."管理",
                                );
                                $checkResult=app("S_Admin_adminMenu")->updateForModule($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'menuId' => $val["toId"],
                                    'moduleName' => $dataObj->data->moduleData["name"]."管理",
                                );
                                $checkResult=app("S_Admin_adminFunc")->updateForModule($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'menuId' => $val["toId"],
                                    'module' => "admin/Article",
                                    'action' => "index",
                                    'actionName' => $dataObj->data->moduleData["name"]."列表",
                                );
                                $checkResult=app("S_Admin_adminFunc")->updateForAction($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 删除路由
     * @param string $paramObj
     */
    public function routeDel($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $dataObj->data->id=trim($dataObj->request->id);
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //查询对应关系
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'fromId' => $dataObj->data->id,
                'type' => "module",
            );
            $checkResult=app("S_Admin_map_relation")->allData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                if($result){
                    foreach($result as $val){
                        if ($final_arr["error_no"] == 0) {
                            //删除节点关系
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'toId' => $val["toId"],
                                'fromId' =>$val["fromId"],
                                'type' => "module",
                            );
                            $checkResult=app("S_Admin_map_relation")->delete($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //删除菜单
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'id' => $val["toId"],
                            );
                            $checkResult=app("S_Admin_adminMenu")->delete($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //删除节点
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'menuid' => $val["toId"],
                            );
                            $checkResult=app("S_Admin_adminFunc")->deleteByMenuId($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }
}