<?php

namespace app\logic\admin;

class L_category
{
    /**
     * 初始化分类
     */
    public function init_category($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "field"=>"id",
            );
            $checkResult=app("S_Admin_category")->allData($paramsObj);
            if($checkResult["error_no"]==0){
                $categoryResult=$checkResult["result"];
                foreach($categoryResult as $value){
                    if($final_arr["error_no"]==0){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$value["id"],
                        );
                        $checkResult=app("S_Admin_category")->init($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }
                    if($final_arr["error_no"]){
                        break;
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新链接地址
     */
    public function updateLinkurl($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'dataId' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            //查询数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "dataType"=>$dataObj->request->dataType,
                "dataId"=>$dataObj->request->dataId,
                "field"=>"id,catDir,name",
            );
            $checkResult=app("S_Admin_category")->allData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $listRule=getModuleListUrlRule($dataObj->request->dataId)["rule"];
                if($result && $listRule){
                    $data=array();
                    foreach($result as $val){
                        $replace=array(
                            "catdir"=>$val["catDir"],
                            "catid"=>$val["id"],
                            "catname"=>$val["name"],
                        );
                        $linkurl=urlRuleReplace($replace,$listRule);
                        $data["id"][]=$val["id"];
                        $data["data"][$val["id"]]=$linkurl;
                    }

                    $case="";
                    foreach($data["id"] as $id){
                        if(isset($data["data"][$id])){
                            $case.="WHEN {$id} THEN '{$data["data"][$id]}' ";
                        }
                    }
                    $tableName=app("cmsTable")::category();
                    $sql="update `{$tableName}` set linkurl = CASE id {$case} END where id IN(".implode(",",$data["id"]).")";
                    Db()->execute($sql);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 检测目录
     */
    public function checkDir($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'dataId' => 'require',
                'catDir' => 'require',
                'id' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            //查询数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "dataType"=>$dataObj->request->dataType,
                "dataId"=>$dataObj->request->dataId,
                "catDir"=>$dataObj->request->catDir,
                "id"=>$dataObj->request->id,
                "field"=>"id",
            );
            $checkResult=app("S_Admin_category")->checkDir($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if($result){
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("category.dir_exists"));
                }else{
                    $catDirReg=config("category.reg.catDir","");
                    if(preg_match("/^{$catDirReg}$/i", $dataObj->request->catDir)) {

                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("category.catDirUnqualified"));
                    }
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}