<?php

namespace app\logic\admin;

class L_adminRole
{
    /**
     * add
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $final_arr = logInit();       //初始化日志信息,也是最终结果信息 最外层if 判断
        if ($final_arr["error_no"] == 0) {
            //调用 数据库层代理执行
            $checkResult = app("S_Admin_adminRole")->store($paramObj);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];  //吧响应结果数据赋值到最终数组 结果数据
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }

    /**
     * set
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {

        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。
        $final_arr = logInit();
        /* //校验数据合法=====================================================
         if ($final_arr["error_no"] == 0) {
             $mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
             $params = parseToArr($paramObj, "params", array());//  参数
             $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则

             ));
             $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
             $dataDefault = array();

             $paramsObj = paramsObj();  //新建一个空对象
             $paramsObj->params = $params;
             $paramsObj->mixed = $mixed;
             $paramsObj->rules = $rules;
             $paramsObj->messages = $messages;
             $paramsObj->dataDefault = $dataDefault;

             $checkResult = app("verifyParam")::validatorRequest($paramsObj);
             if ($checkResult["error_no"] == 0) {
                 $dataObj->request = $checkResult["result"];
             } else {
                 $final_arr = logCallErrorMsg($final_arr, $checkResult);
             }
         }*/

        if ($final_arr["error_no"] == 0) {
            $checkResult = app("S_Admin_adminRole")->update($paramObj);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function listData($paramObj = ""): array
    {

        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取列表
            $checkResult = app("S_Admin_adminRole")->listData($dataObj);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }

    //角色鉴权
    public static function roleAuthentication($paramObj = "")
    {
        // ["uid" => $uid, "controller" => $controller ,"action" => $action];
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。
        $final_arr = logInit();

        //校验参数==============================
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $params = parseToArr($paramObj, "params", array());//  参数
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'uid' => 'require',
                'other' => '',
                'module' => 'require',
                'action' => 'require',
            ));


            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }


        //判断全局方法同步,键值方法反查键名
        if ($final_arr["error_no"] == 0) {
            $global = config("rbac.global" ,array());
            $action = array_search($dataObj->request->action, $global);  //反查键名
            if ($action) {
                //修改判断方法为查询结果
                $dataObj->request->action=$action;
            }
        }

        //判断指定控制器方法同步,键值方法反查键名
        if ($final_arr["error_no"] == 0) {
            $local = config("rbac.local.".$dataObj->request->module ,array());
            $action = array_search($dataObj->request->action, $local);  //反查键名
            if ($action) {
                //修改判断方法为查询结果
                $dataObj->request->action=$action;
            }
        }


        //额外放行最后判断是否为不鉴权的控制器和方法
        if ($final_arr["error_no"] == 0) {
            //先查控制器是否有通配符
            $ok = config("rbac.no." . $dataObj->request->module."/*","0");
            if ($ok == "1" ) {
                return $final_arr;
            }
            //再查控制器是否单独放行指定方法
            $ok = config("rbac.no." . $dataObj->request->module . "/" . $dataObj->request->action,"0");
            if ($ok == "1") {
                return $final_arr;
            }
        }


        //读取 管理员角色信息
        if ($final_arr["error_no"] == 0) {
            $paramsObj = getParamsObj();
            $paramsObj->params = ["id" => $dataObj->request->uid];//  参数
            $ret = app("S_Admin_admin")->info($paramsObj);
            if ($ret["error_no"] == 0) {
                $dataObj->adminInfo = $ret["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
                if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                    //修改一下返回提示
                    $final_arr["error_msg"] = lang2("管理员用户不存在");  //角色不存在
                }
            }

        }
        //判断是否超管
        if ($final_arr["error_no"] == 0 && $dataObj->adminInfo["isAdmin"]) {
            return $final_arr;
        }

        //读取 角色信息,判断角色是否还可用
        if ($final_arr["error_no"] == 0) {
            $paramsObj = getParamsObj();
            $paramsObj->params = ["id" => $dataObj->adminInfo["roleId"]];//  参数
            $ret = app("S_Admin_adminRole")->info($paramsObj);
            if ($ret["error_no"] == 0) {
                $dataObj->roleInfo = $ret["result"];
                if ($dataObj->roleInfo["status"] != 1) {
                    //角色已禁用
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE, app("errorCode")::PERMISSION_DENIED, lang("admin.Role disabled"));
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
                if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                    //修改一下返回提示
                    $final_arr["error_msg"] = lang("admin.Role does not exist");  //角色不存在
                }
            }

        }

        //读取 控制器方法名称对应的功能id
        if ($final_arr["error_no"] == 0) {
            $paramsObj = getParamsObj();
            $paramsObj->params=array(
                "action"=>$dataObj->request->action,
                "module"=>$dataObj->request->module,
            );
            if ($dataObj->request->other){
                $paramsObj->params["other"]=$dataObj->request->other;
            }
            $ret = app("S_Admin_adminFunc")->infoModuleAction($paramsObj);
            if ($ret["error_no"] == 0) {
                $dataObj->funcInfo = $ret["result"];
            } else {
                //功能未配置到数据库
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE, app("errorCode")::PERMISSION_DENIED, lang("admin.Function not configured to database"));
            }
        }
        if ($final_arr["error_no"] == 0) {
            //判断结果,正常应该只有1条记录,如果没有或者很多说明错误
            if ($ret["error_no"] == 0 && count($dataObj->funcInfo) == 1) {
                $dataObj->funcInfo = $dataObj->funcInfo[0];
            } else {
                //功能配置错误
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE, app("errorCode")::PERMISSION_DENIED, lang2("功能数据库配置错误"));
            }
        }


        if ($final_arr["error_no"] == 0) {
            $paramsObj = getParamsObj();
            $paramsObj->params = array(
                "roleId" => $dataObj->adminInfo["roleId"]
            );//  参数
            //都读取出来,而不是只读取需要权限 有利于缓存
            $ret = app("S_Admin_adminRoleFunc")->getRoleBindFunc($paramsObj);
            if ($ret["error_no"] == 0) {
                //判断权限,如果数字不存在绑定功能id数组内,报权限不足
                if (!in_array($dataObj->funcInfo["id"], $ret["result"])) {
                    //权限不足
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE, app("errorCode")::PERMISSION_DENIED, lang("admin.InsufficientPermissions"));
                }
            } else {
                //功能未配置到数据库
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }
        return $final_arr;
    }

    function getAllKeyVal(): array
    {
        $paramsObj = paramsObj();  //获取空对象
        $Result = app("S_Admin_adminRole")->getAll($paramsObj);
        $Kv = array();
        foreach ($Result["result"] as $item) {
            $Kv [$item["id"]] = $item["name"];
        }

        return $Kv;
    }


}