<?php

$catDirReg=config("category.reg",array());

router()->group(function () use($catDirReg) {
    $moduleData=module("all");
    if($moduleData){
        $pattern=array(
            "catdir"=>$catDirReg["catDir"],
            "page"=>$catDirReg["page"],
            "articleId"=>$catDirReg["articleId"],
            "mix_articleId"=>$catDirReg["mix_articleId"],
            "catId"=>$catDirReg["catId"],
            "year"=>$catDirReg["year"],
            "month"=>$catDirReg["month"],
            "day"=>$catDirReg["day"],
        );
        $replace=array(
            "catdir"=>"<catdir>",
            "page"=>"<page>",
            "itemid"=>"<articleId>",
            "mix_itemid"=>"<mix_articleId>",
            "catid"=>"<catId>",
            "year"=>"<year>",
            "month"=>"<month>",
            "day"=>"<day>",
        );
        foreach($moduleData as $mval){
            if($mval["module"]=="article" && $mval["isLink"]=="0"){
                router()->get($mval["urlPath"], "Article/index")->append(array("moduleId"=>$mval["id"]));

                $moduleListUrlRule=getModuleListUrlRule($mval["id"],$replace);
                $moduleItemUrlRule=getModuleItemUrlRule($mval["id"],$replace);

                $listRule=$moduleListUrlRule["rule"]; //列表路由
                $listRulePage=$moduleListUrlRule["rulePage"]; //列表分页路由
                $conRule=$moduleItemUrlRule["rule"]; //内容路由

                if(($index=strpos($listRule,"?")) !==false){
                    $listRule=substr($listRule,0,$index);
                }
                if(($index=strpos($listRulePage,"?")) !==false){
                    $listRulePage=substr($listRulePage,0,$index);
                }
                if(($index=strpos($conRule,"?")) !==false){
                    $conRule=substr($conRule,0,$index);
                }
                router()->get($mval["urlPath"]."/".rtrim($listRule,"/"), "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($listRulePage,"/"), "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($conRule,"/"), "Article/detail")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);

                router()->get($mval["urlPath"]."/".rtrim($listRule,"/")."/", "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($listRulePage,"/")."/", "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($conRule,"/")."/", "Article/detail")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
            }
        }
    }
}, ["webStatus","globalConfig","securityCsp","securityXss"]);

