<?php

namespace app\db\admin;

use app\db\D_article as D_article_base;
use ltcms\db\Db_raw;

class D_article extends D_article_base
{
    /**
     * 获取位置信息
     * @param string $paramObj
     */
    public function getPositionData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field("min(id) as startId,max(id) as endId")->find();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取文章数据
     * @param string $paramObj
     */
    public function getAllData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|integer|gt:0',
                'page' => '',
                'pageSize' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["page"] = "1";
            $dataDefault["pageSize"] = "100";
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->order("id","asc")->page($dataObj->request->page,$dataObj->request->pageSize)->select();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取进度
     * @param string $paramObj
     */
    public function getProccess($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|integer|gt:0',
                'pageSize' => '',
                'fid' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["pageSize"] = "100";
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $condition = array();
                if (is_numeric($dataObj->request->fid)) {
                    $condition[] = array(
                        "id", ">=", $dataObj->request->fid
                    );
                }
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->order("id","asc")->where($condition)->limit($dataObj->request->pageSize)->select();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 文章列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|integer|gt:0',
                'title' => '',
                'author' => '',
                'status' => '',
                'thumb' => '',
                'recycle' => '',
                'userId' => '',
                'level' => '',
                'field' => '',
                'format' => '',
                'categoryId' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if ($dataObj->request->status) {
                $statusIds = is_array($dataObj->request->status) ? $dataObj->request->status : explode(",", $dataObj->request->status);
                $condition[] = array(
                    "status", "IN", $statusIds
                );
            }
            if ($dataObj->request->recycle) {
                $condition[] = array(
                    "recycle", "=", $dataObj->request->recycle
                );
            }
            if ($dataObj->request->author) {
                $condition[] = array(
                    "author", "=", $dataObj->request->author
                );
            }
            if ($dataObj->request->thumb) {
                if($dataObj->request->thumb=="1"){
                    $condition[] = array(
                        "thumb", "!=", ""
                    );
                }else if($dataObj->request->thumb=="2"){
                    $condition[] = array(
                        "thumb", "=", ""
                    );
                }
            }
            if ($dataObj->request->title) {
                $raw=new Db_raw();
                $raw->setContent("LOCATE('{$dataObj->request->title}',`title`)");
                $condition[] = array(
                    $raw, ">", 0
                );
            }
            if (is_numeric($dataObj->request->categoryId)) {
                //查询分类id
                $categoryId=array(-1);
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->request->categoryId,
                    "field"=>"arr_child_id",
                );
                $checkResult=app("S_Admin_category")->info($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        $categoryId=explode(",",$result["arr_child_id"]);
                    }
                }
                $condition[] = array(
                    "categoryId", "in", $categoryId
                );
            }
            $order=setting("order",$dataObj->request->moduleId)??"id desc";
            $order=explode(" ",$order);
            if (count($order)!=2){ //防呆
                $order=array("id","desc");
            }
            try {
                //关联表
                $db=Db();
                if($dataObj->request->level){
                    $commendModuleData=app("cmsTable")::commendModuleData();
                    $db->join("{$commendModuleData} as cmd","cmd.moduleId={$dataObj->request->moduleId} and cmd.commendId={$dataObj->request->level} and cmd.dataId=id");
                }
                $result = $db->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->order($order[0],$order[1])->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 相关数据
     */
    protected function relatedData($ids,$moduleId)
    {
        $result=array();
        //获取文章级别
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "dataId"=>$ids,
            "moduleId"=>$moduleId,
        );
        $checkResult=app("S_Admin_commendModuleData")->getLevelData($paramsObj);
        if ($checkResult["error_no"] == 0) {
            $result = $checkResult["result"];
        }
        return $result;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'number',
                'categoryId' => 'number',
                'moduleId' => 'require|integer',
                'webTitle' => '',
                'webKeyWords' => '',
                'title' => 'require',
                'thumb' => '',
                'description' => '',
                'status' => '',
                'author' => '',
                'addTime' => '',
                'isAdmin' => 'require|integer',
                'userId' => 'require|integer',
                'recycle' => '',
                'level' => 'number',
                'post_fields' => '',
                'hits' => '',
            );
            $dataDefault = array();
            $dataDefault["recycle"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $paramsObj->noFilter=array("thumb");
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        $post_fields=$dataObj->request->post_fields?$dataObj->request->post_fields:array();
        if ($final_arr["error_no"] == 0) {
            if($post_fields){
                //字段检测
                $checkResult=fields_check($dataObj->request->moduleId,$post_fields);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $data = array();
                $data["moduleId"] = $dataObj->request->moduleId;
                $data["title"] = $dataObj->request->title;
                $data["isAdmin"] = $dataObj->request->isAdmin;
                $data["userId"] = $dataObj->request->userId;
                if ($dataObj->request->webKeyWords || $dataObj->request->description) {
                    $data["webKeyWords"] = $dataObj->request->webKeyWords ? $dataObj->request->webKeyWords : $dataObj->request->description;
                }
                if ($dataObj->request->webTitle || $dataObj->request->title) {
                    $data["webTitle"] = $dataObj->request->webTitle ? $dataObj->request->webTitle : $dataObj->request->title;
                }
                if ($dataObj->request->thumb) {
                    $data["thumb"] = $dataObj->request->thumb;
                }
                if (isset($dataObj->request->hits)) {
                    $data["hits"] = $dataObj->request->hits;
                }
                if ($dataObj->request->categoryId) {
                    $data["categoryId"] = $dataObj->request->categoryId;
                }
                if ($dataObj->request->description) {
                    $data["description"] = $dataObj->request->description;
                }
                if (is_numeric($dataObj->request->status)) {
                    $data["status"] = $dataObj->request->status;
                }
                if ($dataObj->request->author) {
                    $data["author"] = $dataObj->request->author;
                }
                if ($dataObj->request->level) {
                    $data["level"] = $dataObj->request->level;
                }
                if ($dataObj->request->id) {
                    $data["id"] = $dataObj->request->id;
                }
                if($post_fields){
                    $data=array_merge($data,$post_fields);
                }
                if ($dataObj->request->addTime) {
                    $data["addTime"] = app("ltcmsTime")::getTime($dataObj->request->addTime);
                } else {
                    $data["addTime"] = app("ltcmsTime")::getTime();
                }
                $data["updateTime"] = $data["addTime"];
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->data($data)->insert();
                $dataObj->data->insert_id=$result["insert_id"];
                $return = array();
                $return["id"] = $result["insert_id"];
                $return["affected_rows"] = $result["affected_rows"];
                $return["moduleId"] = $dataObj->request->moduleId;
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        if ($final_arr["error_no"] == 0) {
            //录入推荐信息
            if($dataObj->request->level){
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'dataId' => $dataObj->data->insert_id,
                    'moduleId' => $dataObj->request->moduleId,
                    'commendId' => $dataObj->request->level,
                );
                $checkResult = app("S_Admin_commendModuleData")->record($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'categoryId' => 'number',
                'moduleId' => 'require|integer|gt:0',
                'id' => 'require',
                'webTitle' => '',
                'webKeyWords' => '',
                'title' => '',
                'thumb' => '',
                'description' => '',
                'status' => '',
                'author' => '',
                'addTime' => '',
                'recycle' => '',
                'level' => 'number',
                'verify' => '',
                'linkUrl' => '',
                'post_fields' => '',
                'hits' => '',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $paramsObj->noFilter=array("thumb");
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->request->verify && !is_array($dataObj->request->id)) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "moduleId" => $dataObj->request->moduleId,
                    "id" => $dataObj->request->id,
                    "verify" => 1,
                );
                $checkResult = $this->info($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        $post_fields=fields_update($dataObj->request->moduleId,$dataObj->request->post_fields);
        if ($final_arr["error_no"] == 0) {
            if($post_fields){
                //字段检测
                $checkResult=fields_check($dataObj->request->moduleId,$post_fields);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            //判断 id是否为数组,如果是数组,返回id数组,如果不是数组,返回单成员数组
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition[] = array(
                "id", "IN", $ids
            );
            $data = array();
            if (isset($dataObj->request->webTitle)) {
                $data["webTitle"] = $dataObj->request->webTitle;
            }
            if (isset($dataObj->request->webKeyWords)) {
                $data["webKeyWords"] = $dataObj->request->webKeyWords;
            }
            if (isset($dataObj->request->linkUrl)) {
                $data["linkUrl"] = $dataObj->request->linkUrl;
            }
            if (isset($dataObj->request->webKeyWords) || isset($dataObj->request->description)) {
                $data["webKeyWords"] = $dataObj->request->webKeyWords ? $dataObj->request->webKeyWords : $dataObj->request->description;
            }
            if (isset($dataObj->request->webTitle) || isset($dataObj->request->title)) {
                $data["webTitle"] = $dataObj->request->webTitle ? $dataObj->request->webTitle : $dataObj->request->title;
            }
            if (isset($dataObj->request->title)) {
                $data["title"] = $dataObj->request->title;
            }
            if (isset($dataObj->request->categoryId)) {
                $data["categoryId"] = $dataObj->request->categoryId;
            }
            if (isset($dataObj->request->thumb)) {
                $data["thumb"] = $dataObj->request->thumb;
            }
            if (isset($dataObj->request->hits)) {
                $data["hits"] = $dataObj->request->hits;
            }
            if (isset($dataObj->request->description)) {
                $data["description"] = $dataObj->request->description;
            }
            if (isset($dataObj->request->status)) {
                $data["status"] = $dataObj->request->status;
            }
            if (isset($dataObj->request->author)) {
                $data["author"] = $dataObj->request->author;
            }
            if (isset($dataObj->request->addTime)) {
                $data["addTime"] = $dataObj->request->addTime?app("ltcmsTime")::getTime($dataObj->request->addTime):0;
            }
            if (isset($dataObj->request->recycle)) {
                $data["recycle"] =  $dataObj->request->recycle;
            }
            if (isset($dataObj->request->level)) {
                $data["level"] =  $dataObj->request->level;
            }
            if($post_fields){
                $data=array_merge($data,$post_fields);
            }
            if ($data) {
                $data["updateTime"] = (array_key_exists("addTime", $data) && $data["addTime"] > app("ltcmsTime")::getTime()) ? $data["addTime"] : app("ltcmsTime")::getTime();
                try {
                    $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->where($condition)->data($data)->update();
                    $return = array();
                    $return["id"] = $dataObj->request->id;
                    $return["moduleId"] = $dataObj->request->moduleId;
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["moduleId"] = $dataObj->request->moduleId;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        if ($final_arr["error_no"] == 0) {
            //录入推荐信息
            if (isset($dataObj->request->level)) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'dataId' => $dataObj->request->id,
                    'moduleId' => $dataObj->request->moduleId,
                    'commendId' => $dataObj->request->level,
                );
                $checkResult = app("S_Admin_commendModuleData")->record($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新 linkurl 数据
     * @param string $paramObj
     */
    public function updateLinkurl($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try{
                $condition=array();
                $condition[] = array(
                    "id", "=", $dataObj->request->id
                );
                $result=Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->where($condition)->field("id,categoryId,addTime")->select();
                if($result) {
                    $rule=getModuleItemUrlRule($dataObj->request->moduleId)["rule"];
                    //更新数据
                    foreach($result as $val){
                        if ($final_arr["error_no"] == 0) {
                            $replace=array(
                                "itemid"=>$val["id"],
                                "year"=>app("ltcmsTime")::getDateTime('Y', $val["addTime"]),
                                "month"=>app("ltcmsTime")::getDateTime('m', $val["addTime"]),
                                "day"=>app("ltcmsTime")::getDateTime('d', $val["addTime"]),
                                "mix_itemid"=>app("ltcmsConfusionCode")->enCode($val["id"]),
                            );
                            $categoryData=$val["categoryId"]?category('module',$dataObj->request->moduleId,$val["categoryId"]):array();
                            if($categoryData){
                                $replace["catid"]=$categoryData["id"];
                                $replace["catdir"]=$categoryData["catDir"];
                            }else{
                                $replace["catid"]="";
                                $replace["catdir"]="";
                            }
                            $linkurl=urlRuleReplace($replace,$rule);
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$val["id"],
                                "linkUrl"=>$linkurl,
                                "moduleId"=>$dataObj->request->moduleId,
                            );
                            $checkResult=$this->update($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'moduleId' => 'require|integer|gt:0',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->where($condition)->delete();
                $return = array();
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
            if ($final_arr["error_no"] == 0) {
                //删除推荐信息
                foreach($ids  as $id){
                    if ($final_arr["error_no"] == 0) {
                        $paramsObj = paramsObj();
                        $paramsObj->params = array(
                            'dataId' => $id,
                            'moduleId' => $dataObj->request->moduleId,
                        );
                        $checkResult = app("S_Admin_commendModuleData")->record($paramsObj);
                        if ($checkResult["error_no"] == 0) {

                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                    if ($final_arr["error_no"]) {
                        break;
                    }
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}