<?php

namespace app\client\common;

class C_appStore
{
    /**
     * 使用激活码
     * @param string $paramObj
     */
    public function usedByCardName($paramObj = "")
    {
        $messages=array(
            "cardName.require"=>"请输入卡码/激活码",
        );
        $loginInfo=ltcmsLoginInfo();
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj->messages=$messages;
        $paramsObj->params = array(
            "token"=>getVal($loginInfo,"token"),
            "seller_id"=>data("cms.info.seller_id",0),
        );
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Common_appStore")->usedByCardName($paramsObj);
        if ($checkResult["error_no"] == 0) {
            //自动更新key
            app("L_Api_goods")->updateKey();
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 下载文件[执行]
     * @param string $paramObj
     */
    public function downloadFile($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Common_appStore")->downloadFile($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 安装[执行]
     * @param string $paramObj
     */
    public function install($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Common_appStore")->install($paramsObj);
        if ($checkResult["error_no"] == 0) {

        } else {
            recordErrorLog($checkResult); //记录错误信息
            echo $checkResult["error_msg"];
        }
    }

    /**
     * 插件安装[执行]
     * @param string $paramObj
     */
    public function pluginInstall($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Common_appStore")->pluginInstall($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 卸载[执行]
     * @param string $paramObj
     */
    public function uninstall($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Common_appStore")->uninstall($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }

    /**
     * 设置[执行]
     * @param string $paramObj
     */
    public function setUpView($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Common_appStore")->setUpView($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return $checkResult["result"];
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return view("error/index",$checkResult);
        }
    }
}