<?php

namespace app\client\admin;

class C_module
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $messages=array();
        $messages["name.require"]="请输入模块名称";
        $messages["module.requireIf"]="请选择所属模型";
        $messages["urlPath.requireIf"]="请输入模块目录";
        $messages["isLink.require"]="请选择模块类型";
        $messages["isMenu.require"]="请选择导航菜单";
        $messages["isBlank.require"]="请选择新窗口打开";
        $messages["linkUrl.requireIf"]="请输入链接地址";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_module")->store($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            $extra=$checkResult["extra"];
            if($result['id']){
                //更新模块缓存
                upModuleCache($result['id']);
                //模块添加路由
                addRouteModule($result['id']);
                //更新设置
                upSettingCache($result['id']);
                //添加分类
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'name' => $extra["name"],
                    'dataType' => 'module',
                    'dataId' => $result['id'],
                    'disabled' => 1,
                );
                app("C_Admin_category")->store($paramsObj);
            }
            return apiResult(true,"success",0,$result,$extra);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $messages=array();
        $messages["name.require"]="请输入模块名称";
        $messages["module.require"]="请选择所属模型";
        $messages["urlPath.requireIf"]="请输入模块目录";
        $messages["isLink.require"]="请选择模块类型";
        $messages["isMenu.require"]="请选择导航菜单";
        $messages["isBlank.require"]="请选择新窗口打开";
        $messages["linkUrl.requireIf"]="请输入链接地址";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_module")->update($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result['id']){
                //更新模块缓存
                upModuleCache($result['id']);
                //模块更新路由
                updateRouteModule($result['id']);
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 补充路由数据
     * @param string $paramObj
     */
    public function supplyRoute($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_module")->supplyRoute($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 文章列表数据
     * @param string $paramObj
     */
    public function listData($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_module")->listData($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 文章详情
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "format"=>1,
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_module")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_module")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result['id']){
                foreach($result['id'] as $id){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$id,
                    );
                    $tmp=app("L_Common_caches")->updateModule($paramsObj);
                    if($tmp["error_no"]){
                        recordErrorLog($tmp); //记录错误信息
                    }

                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$id,
                    );
                    $tmp=app("L_Admin_module")->deleteModuleData($paramsObj);
                    if($tmp["error_no"]){
                        recordErrorLog($tmp); //记录错误信息
                    }
                }
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}