<?php

namespace app\api\controller;

use app\client\api\C_test;
use app\logic\common\L_secretIdKey;

class Test
{
    public $c_test;

    public function __construct()
    {
        $this->c_test = new C_test();
    }

    /**
     * 获取php版本
     */
    public function phpVersion()
    {
        $this->c_test->phpVersion();
    }

    /**
     * 测试
     */
    public function index()
    {
        echo "默认";
        exit;

//        $filePath = './2.txt';//文件
//        $fp=fopen($filePath,"r");
//        //set_time_limit(1);
//        //取得文件大小
//        $fileSize=filesize($filePath);
//        $buffer=5000;
//        $bufferCount=0;
//        header("Content-type:application/octet-stream");//设定header头为下载
//        header("Content-Disposition: attachment; filename=2.txt");//文件名
//        if (!empty($_SERVER['HTTP_RANGE'])){
//            //切割字符串
//            $range = explode('-',substr($_SERVER['HTTP_RANGE'],6));
//            fseek($fp,$range[0]);//移动文件指针到range上
//            header('HTTP/1.1 206 Partial Content');
//            header("Content-Range: bytes $range[0]-$fileSize/$fileSize");
//            header("content-length:".$fileSize-$range[0]);
//        }else{
//            header("Accept-Length:".$fileSize);//响应大小
//        }
//
//        ob_end_clean();//缓冲区结束
//        ob_implicit_flush();//强制每当有输出的时候,即刻把输出发送到浏览器
//        header('X-Accel-Buffering: no'); // 不缓冲数据
//        while(!feof($fp)&&$fileSize-$bufferCount>0){//循环读取文件数据
//            $data=fread($fp,$buffer);
//            $bufferCount+=$buffer;
//            echo $data;//输出文件
//            sleep(1);
//        }
//        fclose($fp);
    }

    /**
     * 分片下载
     */
    public function download()
    {
        $url = request()->param("url", "http://www.cms.com/upload/0e77e9c89bee49812e66f115c48eeafd.jpg");
        if ($url) {
            error_reporting(0);
            $buffer = 1024 * 3;//每个切片大小 单位字节
//            $filePath=str_replace("\\","/",runtimePath("cache/download/tmp"));
//            makeDir($filePath);
//            $filename=$filePath."test.jpg";
            ob_end_clean();
            $filename = "test.jpg";
//            header('Content-Type: ' . 'application/octet-stream;charset=utf-8;');
//            header('Content-Disposition: attachment; filename=' . $filename);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            $begin = 0;
            do {
                $end = $begin + $buffer;
                curl_setopt($ch, CURLOPT_RANGE, $begin . '-' . $end);
                header('Content-Range:bytes ' . $begin . '-' . $end);
                $content = curl_exec($ch);
                $info = curl_getinfo($ch);
                if ($info['http_code'] == "206") {
                    echo $begin . "@" . $end . PHP_EOL;
//                    echo $content;
                    $begin = $end + 1;
                    unset($content);
                } else {
                    break;
                }
            } while (true);
        } else {
            echo "请输入url";
        }
    }

    /**
     * 获取文件信息
     * @param $url
     */
    public function getFileInfo($url)
    {
        // 初始化cURL会话
        $ch = curl_init($url);

        // 设置cURL选项
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, true); // 将结果保存到变量而不直接输出
        curl_setopt($ch, CURLOPT_NOBODY, true); // 只获取头部信息，不下载文件内容
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 3);// 单位 秒，超时限制。

        // 发送HTTP HEAD请求获取头部信息

        $header = curl_exec($ch);
        // 关闭cURL会话
        curl_close($ch);

        $headArr = explode("\r\n", $header);
        $headers = array();
        if ($headArr) {
            foreach ($headArr as $key => $val) {
                if ($val) {
                    list($itemKey, $itemVal) = array_pad(explode(":", $val), 2, "");
                    if ($itemVal) {
                        $headers[strtolower($itemKey)] = $itemVal;
                    }
                }
            }
        }
        return $headers;
    }


    /**
     * 获取获取安全key
     */
    public function getSecretKey()
    {
        $s = new L_secretIdKey();
        if (!$s->getPublicKey()||!$s->getSecretIdKey()){
            $err=$s->err;

        }else{
            echo $s->secretId."\r\n" ;
            echo $s->secretKey."\r\n" ;
        }



    }

}