<?php

namespace app\admin\controller;

use app\client\admin\C_setting;

class Setting
{
    public $c_setting;

    public function __construct()
    {
        $this->c_setting = new C_setting();
    }

    /**
     * @actionName  网站设置
     * @show 1
     * 展示设置
     */
    public function site()
    {
        $pid=1;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
        );
        $response= $this->c_setting->getSetting($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        $data["pcDirList"]=config("template.default_pc_list");
        $data["mobileDirList"]=config("template.default_mobile_list");
        $data["skinList"]=config("template.default_skin_list");
        return view("admin/setting/site",$data);
    }

    /**
     * @actionName  扩展设置
     * @show 1
     * 扩展设置
     */
    public function extend()
    {
        $pid=4;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
        );
        $response= $this->c_setting->getSetting($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $settingData=config("setting_data");
        $data=array();
        $data["settingData"] = $settingData;
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/extend",$data);
    }

    /**
     * @actionName  seo设置
     * @show 1
     * 展示设置
     */
    public function seo()
    {
        $pid=2;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
        );
        $response= $this->c_setting->getSetting($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/seo",$data);
    }

    /**
     * 缓存设置
     * @return mixed
     */
    public function cache()
    {
        $pid=5;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
        );
        $response= $this->c_setting->getSetting($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/cache",$data);
    }

    /**
     * @actionName  性能优化
     * @show 1
     * 展示设置
     */
    public function optimize()
    {
        $pid=3;
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$pid,
        );
        $response= $this->c_setting->getSetting($paramsObj);
        $result=array();
        if($response["success"]){
            $result=$response["data"];
        }
        $data=array();
        $data["rowData"]=$result;
        $data["pid"]=$pid;
        return view("admin/setting/index_optimize",$data);
    }

    /**
     * @actionName  记录数据
     * @show 2
     * 展示设置
     */
    public function record()
    {
        $result= $this->c_setting->record();
        return jsonResponse($result);
    }

    /**
     * @actionName  安装初始化设置
     */
    public function installInit()
    {
        $result= $this->c_setting->installInit();
        return jsonResponse($result);
    }

    /**
     * @actionName  记录数据批量
     * @show 2
     * 展示设置
     */
    public function recordBatch()
    {
        $result= $this->c_setting->recordBatch();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除数据
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result= $this->c_setting->delete();
        return jsonResponse($result);
    }
}