<?php

namespace app\admin\controller;


use app\client\admin\C_memberAdmin;
use ltcms\lib\Request;


//控制层 渲染最后视图信息,模拟请求数据
class MemberAdmin
{
    public $client = null;

    /**
     * @menuName 后台权限
     * 上面的是菜单的名字
     * @moduleName 管理员管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_memberAdmin();
    }

    /**
     * @actionName  添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $RoleKv = app("L_Admin_adminRole")->getAllKeyVal();
        $data = array();
        $data["roleKv"] = $RoleKv;
        $data["request"] = request()->param();
        return view("admin/memberAdmin/create", $data);
    }

    /**
     * @actionName   添加接口
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  修改密码
     */
    public function modifyPwd()
    {
        $result = $this->client->getInfo();
        if ($result["success"]) {
            $result = $result["data"];
        }
        $data = array();
        $data["info"] = $result;
        $data["request"] = request()->param();
        return view("admin/memberAdmin/modifyPwd", $data);
    }

    /**
     * @actionName  修改密码[自己]
     */
    public function modifyPwdSelf()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/memberAdmin/modifyPwdSelf", $data);
    }

    /**
     * 修改密码[密码]
     */
    public function modifyPwdDo()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $result = $this->client->getInfo();
        if ($result["success"]) {
            $result = $result["data"];
        }
        $RoleKv = app("L_Admin_adminRole")->getAllKeyVal();
        $data = array();
        $data["roleKv"] = $RoleKv;
        $data["info"] = $result;
        $data["request"] = request()->param();
        return view("admin/memberAdmin/edit", $data);

    }

    /**
     * @actionName  更新接口
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  详情
     * @show 2
     * 展示设置
     */
    public function getInfo()
    {

        $result = $this->client->getInfo();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  管理员列表
     * @show 1
     * 展示设置
     */
    public function index()
    {

        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "field" => "id,user,status,roleId",
        );
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/memberAdmin/index", $data);
    }

    /**
     * @actionName  设置角色
     * @show 2
     * 展示设置
     */
    public function setRole()
    {
        $result = $this->client->setRole();
        return jsonResponse($result);
    }

    /**
     * @actionName  设置状态
     * @show 2
     * 展示设置
     */
    public function setStatus()
    {
        $result = $this->client->setRole();
        return jsonResponse($result);
    }


}