<?php

namespace ltcms\session;

/**
 * session mysql缓存
 */
class MysqlSession implements \SessionHandlerInterface
{
    private $link;

    /**
     * session_start 之后调用的第一个函数，可用于链接数据库
     * @param string $savePath
     * @param string $sessionName
     * @return bool
     */
    public function open($savePath, $sessionName)
    {
        return true;
    }

    /**
     * session 关闭
     * @return bool
     */
    public function close()
    {
        return true;
    }

    /**
     * 读取 session 数据
     * @param string $sid
     * @return string
     */
    public function read($sid)
    {
        $tbPre=config("database.tb_pre");

        $sql="select `data` from {$tbPre}sessions where sid='{$sid}' and expires > ". LTCMS_TIME;
        $result=Db()->execute($sql);
        return $result?$result[0]["data"]:"";
    }

    /**
     * 写入session 数据
     * @param string $id
     * @param string $data
     * @return bool
     */
    public function write($sid, $data)
    {
        $data = addslashes($data);
        $expires=LTCMS_SESSION_LIFETIME?LTCMS_SESSION_LIFETIME:1800;
        $expires=$expires+LTCMS_TIME;

        $tbPre=config("database.tb_pre");

        $sql="replace into {$tbPre}sessions set sid='{$sid}',expires='{$expires}',`data`='{$data}'";
        $result=Db()->execute($sql);
        if($result){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 销毁session
     * @param string $id
     * @return bool
     */
    public function destroy($sid)
    {
        $tbPre=config("database.tb_pre");

        $sql="delete from {$tbPre}sessions where sid='{$sid}'";
        $result=Db()->execute($sql);
        if($result){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 垃圾回收
     * @param int $maxlifetime
     * @return bool
     */
    public function gc($maxlifetime)
    {
        $tbPre=config("database.tb_pre");

        $sql="delete from {$tbPre}sessions where expires < ".LTCMS_TIME;
        $result=Db()->execute($sql);
        if($result){
            return true;
        }else{
            return false;
        }
    }
}

/**
 * 初始化session 设置
 */
if(LTCMS_SESSION_DOMAIN){
    @ini_set('session.cookie_domain', LTCMS_SESSION_DOMAIN); //cookie有效作用域名
}
@ini_set('session.name', LTCMS_SESSION_NAME?LTCMS_SESSION_NAME:"cms_session"); //设置session名称
@ini_set('session.auto_start', LTCMS_SESSION_AUTO_START?LTCMS_SESSION_AUTO_START:0); //默认关闭session
@ini_set('session.gc_maxlifetime', LTCMS_SESSION_LIFETIME?LTCMS_SESSION_LIFETIME:1800); //设置过期时间
@ini_set('session.cookie_lifetime', LTCMS_SESSION_LIFETIME?LTCMS_SESSION_LIFETIME:1800); //设置cookie有效期
@ini_set('session.cookie_secure', LTCMS_SESSION_COOKIE_SECURE?LTCMS_SESSION_COOKIE_SECURE:0);
@ini_set('session.cookie_httponly', LTCMS_SESSION_COOKIE_HTTPONLY?LTCMS_SESSION_COOKIE_HTTPONLY:0);

$handler = new MysqlSession();
session_set_save_handler($handler, true);

session_cache_limiter('private, must-revalidate');
@session_start();
header("cache-control: private, must-revalidate");

