<?php

namespace ltcms\route\rule;

/**
 * 路由标识管理类
 */
class RuleName
{
    /**
     * 路由标识
     * @var array
     */
    protected $item = [];

    /**
     * 路由规则
     * @var array
     */
    protected $rule = [];

    /**
     * 路由分组
     * @var array
     */
    protected $group = [];

    /**
     * 注册路由标识
     */
    public function setName($name, RuleItem $ruleItem, $first = false)
    {
        $name = strtolower($name);
        $item = $this->getRuleItemInfo($ruleItem);
        if ($first && isset($this->item[$name])) {
            array_unshift($this->item[$name], $item);
        } else {
            $this->item[$name][] = $item;
        }
    }

    /**
     * 注册路由分组标识
     */
    public function setGroup($name, RuleGroup $group)
    {
        $this->group[strtolower($name)] = $group;
    }

    /**
     * 注册路由规则
     */
    public function setRule($rule, RuleItem $ruleItem)
    {
        $route = $ruleItem->getRoute();
        if (is_string($route)) {
            $this->rule[$rule][$route] = $ruleItem;
        } else {
            $this->rule[$rule][] = $ruleItem;
        }
    }

    /**
     * 根据路由规则获取路由对象（列表）
     */
    public function getRule($rule)
    {
        return $this->rule[$rule] ?? [];
    }

    /**
     * 根据路由分组标识获取分组
     */
    public function getGroup($name)
    {
        return $this->group[strtolower($name)] ?? null;
    }

    /**
     * 清空路由规则
     * @access public
     * @return void
     */
    public function clear()
    {
        $this->item = [];
        $this->rule = [];
    }

    /**
     * 获取全部路由列表
     * @access public
     * @return array
     */
    public function getRuleList($method="",$route="")
    {
        $list = [];
        foreach ($this->rule as $rule => $rules) {
            foreach ($rules as $item) {
                $val = [];
                foreach (['method', 'rule', 'name', 'route', 'domain', 'pattern', 'option'] as $param) {
                    $call        = 'get' . $param;
                    $val[$param] = $item->$call();
                }
                if($method && $method != $val["method"]){
                    continue;
                }
                if($route &&  $route!=$val["route"]){
                    continue;
                }
                if ($item->isMiss()) {
                    $val['rule'] .= '<MISS>';
                }
                $list[] = $val;
            }
        }
        return $list;
    }

    /**
     * 导入路由标识
     */
    public function import(array $item)
    {
        $this->item = $item;
    }

    /**
     * 根据路由标识获取路由信息（用于URL生成）
     */
    public function getName($name = null, $domain = null, $method = '*')
    {
        if (is_null($name)) {
            return $this->item;
        }
        $name   = strtolower($name);
        $method = strtolower($method);
        $result = [];
        if (isset($this->item[$name])) {
            if (is_null($domain)) {
                $result = $this->item[$name];
            } else {
                foreach ($this->item[$name] as $item) {
                    $itemDomain = $item['domain'];
                    $itemMethod = $item['method'];
                    if (($itemDomain == $domain || '-' == $itemDomain) && ('*' == $itemMethod || '*' == $method || $method == $itemMethod)) {
                        $result[] = $item;
                    }
                }
            }
        }
        return $result;
    }

    /**
     * 获取路由信息
     */
    protected function getRuleItemInfo(RuleItem $item)
    {
        return [
            'rule'   => $item->getRule(),
            'method' => $item->getMethod(),
            'suffix' => $item->getSuffix(),
        ];
    }
}
