<?php

namespace ltcms\provider;

use ltcms\App;
use  Closure;
use ltcms\event\RouteLoaded;

/**
 * 系统服务基础类
 */
abstract class Provider
{
    protected $app;

    public function __construct(App $app)
    {
        $this->app = $app;
    }

    /**
     * 加载路由
     * @access protected
     * @param string $path 路由路径
     */
    protected function loadRoutesFrom($path)
    {
        $this->registerRoutes(function () use ($path) {
            include $path;
        });
    }

    /**
     * 注册路由事件
     * @param Closure $closure
     */
    protected function registerRoutes(Closure $closure)
    {
        $this->app->event->listen(RouteLoaded::class, $closure);
    }

    public function __debugInfo()
    {
        return [];
    }
}