<?php

namespace ltcms\lib;

/**
 * 多应用检测
 */
class MultipleApp
{
    private static $_instance;
    protected $data=array();

    private function __construct(){}
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 初始化
     */
    public function loader($appName=""){
        //遍历配置目录
        $configDirs=array(
            LTCMS_PATH."/config",
            LTCMS_APP."/config",
        );
        $configDirs[]=LTCMS_CUSTOM."/config";

        foreach($configDirs as $dir){
            if(is_dir($dir)){
                $funcs=glob($dir."/*.php");
                if($funcs && is_array($funcs)){
                    foreach($funcs as $file){
                        $fileName=strtolower(basename($file,".php"));
                        $tmp=@include $file;
                        if(is_array($tmp)){
                            if(isset($this->data[$fileName])){
                                $this->data[$fileName]=arrFusion($this->data[$fileName],$tmp);
                            }else{
                                $this->data[$fileName]=$tmp;
                            }
                        }
                    }
                }
            }
        }

        $auto_multi_app=isset($this->data["app"]["auto_multi_app"])?$this->data["app"]["auto_multi_app"]:false;
        $default_app=isset($this->data["app"]["default_app"])?$this->data["app"]["default_app"]:"";
        $app_map=isset($this->data["app"]["app_map"])?$this->data["app"]["app_map"]:array();
        $app_express=isset($this->data["app"]["app_express"])?$this->data["app"]["app_express"]:false;
        $log=isset($this->data["log"])?$this->data["log"]:array();


        config()->set(array("log"=>$log));

        if($auto_multi_app){
            if($appName){
                $name=$appName;
                $match=1; //路由完整匹配
                $prefix="/".LTCMS_FILE.".php";
            }else{
                $match=2;//路由去除应用参数在匹配
                $name=LTCMS_FILE;
                $alias="";
                $controllerData=request()->getControllerData(true);
                if($controllerData["app_name"]){
                    $name=$controllerData["app_name"];;
                    if($app_map){
                        $app_map=array_flip($app_map);
                        if(isset($app_map[$name])){
                            $alias=$name;
                            $name=$app_map[$name];
                        }else{
                            $value=array_values($app_map);
                            if(in_array($name,$value)){
                                echo "404";
                                http_response_code(500);
                                exit;
                            }
                        }
                    }
                    if($name){
                        $appPath=LTCMS_APP."/{$name}";
                        if(!is_dir($appPath) && $default_app){
                            if($app_express){
                                $match=1;
                                $name=$default_app;
                            }
                        }
                    }else{
                        if($default_app){
                            $name=$default_app;
                        }
                    }
                }
                $prefix="/".($alias?$alias:$name);
            }
            if($name && !defined("LTCMS_APP_NAME")){
                define('LTCMS_APP_NAME', $name);
            }
        }else{
            $match=3;//路由完整匹配
            $prefix="";
        }

        if(!defined("LTCMS_ROUTE_PREFIX")){
            define('LTCMS_ROUTE_PREFIX', $prefix);
        }
        if(!defined("LTCMS_ROUTE_MATCH")){
            define('LTCMS_ROUTE_MATCH', $match);
        }
    }
}