<?php

namespace ltcms\lib;

use ltcms\db\DbManager;

/**
 * 数据库管理类
 */
class Db extends DbManager
{
    /**
     * 获取配置参数
     * @access public
     * @param string $name    配置参数
     * @param mixed  $default 默认值
     * @return mixed
     */
    public function getConfig($name = '', $default = null)
    {
        if ('' !== $name) {
            return config()->get('database.' . $name, $default);
        }
        return config()->get('database', []);
    }
}
