<?php

namespace ltcms\initializer;

use ltcms\provider\PaginatorProvider;
use ltcms\provider\MultiAppProvider;
use ltcms\App;

class RegisterService
{
    protected $services = [
        PaginatorProvider::class,
    ];

    public function init(App $app)
    {
        $file = $app->getLtcmsPath() . 'services.php';
        $services = $this->services;
        if (is_file($file)) {
            $services = array_merge($services, include $file);
        }
        foreach ($services as $service) {
            if (class_exists($service)) {
                $app->register($service);
            }
        }
    }
}