<?php

namespace ltcms\db\concern;

/**
 * 参数绑定支持
 */
trait Result
{
    /**
     * 处理数据
     * @access protected
     * @param array $result 查询数据
     * @return void
     */
    protected function result(array &$result)
    {
        // JSON数据处理
        if (!empty($this->options['json'])) {
            $this->jsonResult($result);
        }
        // 查询数据处理
        foreach ($this->options['filter'] as $filter) {
            $result = call_user_func_array($filter, [$result, $this->options]);
        }
    }

    /**
     * JSON字段数据转换
     * @access protected
     * @param array $result 查询数据
     * @return void
     */
    protected function jsonResult(array &$result)
    {
        foreach ($this->options['json'] as $name) {
            if (!isset($result[$name])) {
                continue;
            }
            $result[$name] = json_decode($result[$name], true);
        }
    }
}