<?php

namespace ltcms\db;

interface ConnectionInterface
{
    /**
     * 获取当前连接器类对应的Builder类
     * @access public
     * @return string
     */
    public function getBuilderClass();

    /**
     * 获取当前连接器类对应的Query类
     * @access public
     * @return string
     */
    public function getQueryClass();

    /**
     *  查询
     */
    public function select($query);

    /**
     *  查找数据[单条]
     */
    public function find(BaseQuery $query);

    /**
     *  添加数据
     */
    public function insert(BaseQuery $query, $getLastInsID = false);

    /**
     *  更新数据
     */
    public function update(BaseQuery $query);

    /**
     *  删除数据
     */
    public function delete(BaseQuery $query);

    /**
     * 批量插入记录
     * @access public
     * @param BaseQuery   $query   查询对象
     * @param mixed   $dataSet 数据集
     * @return integer
     */
    public function insertAll(BaseQuery $query, array $dataSet = [],$limit = 0);

    /**
     * 连接数据库方法
     * @access public
     * @param array   $config  接参数
     * @param integer $linkNum 连接序号
     * @return mixed
     */
    public function connect(array $config = [], $linkNum = 0);

    /**
     * 设置当前的数据库Db对象
     * @access public
     * @param DbManager $db
     * @return void
     */
    public function setDb(DbManager $db);

    /**
     * 得到某个字段的值
     * @access public
     * @param BaseQuery  $query   查询对象
     * @param string $field   字段名
     * @param mixed  $default 默认值
     * @return mixed
     */
    public function value(BaseQuery $query, $field, $default = null);

    /**
     * 得到某个列的数组
     * @access public
     * @param BaseQuery  $query  查询对象
     * @param string|array $column 字段名 多个字段用逗号分隔
     * @param string $key    索引
     * @return array
     */
    public function column(BaseQuery $query, $column, $key = '');
}