<?php

namespace ltcms\cache;

/**
 * 文件缓存
 * Class Cache_file
 */
class Cache_file implements Cache_contract
{
    protected $configs=array();

    /**
     * 设置配置
     */
    public function setConfig(){
        $this->configs=config("cache.file");
    }

    /**
     *  获取缓存
     */
    public function get($key)
    {
        is_md5($key) or $key = md5($this->configs["pre"].$key);
        $php = LTCMS_CACHE.'/php/'.substr($key, 0, 2).'/'.$key.'.php';
        if(is_file($php)) {
            $str = getFileContent($php);
            $ttl = substr($str, 13, 10);
            if($ttl < LTCMS_TIME) return '';
            return substr($str, 23, 1) == '@' ? substr($str, 24) : unserialize(substr($str, 23));
        } else {
            return '';
        }
    }

    /**
     *  设置缓存
     */
    public function set($key, $val, $ttl = null)
    {
        $ttl=is_null($ttl)?600:$ttl;
        is_md5($key) or $key = md5($this->configs["pre"].$key);
        $ttl = LTCMS_TIME + $ttl;

        //写入数据库
        $tbPre=config("database.connections.mysql.prefix");
        $sql = "REPLACE INTO {$tbPre}cache (`cacheid`,`expireTime`) VALUES ('{$key}','{$ttl}')";
        Db()->execute($sql);

        $val = '<?php exit;?>'.$ttl.(is_array($val) ? serialize($val) : '@'.$val);
        return fileWrite(LTCMS_CACHE.'/php/'.substr($key, 0, 2).'/'.$key.'.php', $val);
    }

    /**
     *  删除缓存
     */
    public function rm($key)
    {
        is_md5($key) or $key = md5($this->configs["pre"].$key);
        return fileDel(LTCMS_CACHE.'/php/'.substr($key, 0, 2).'/'.$key.'.php');
    }

    /**
     *  清除缓存
     */
    public function clear()
    {
        $tbPre=config("database.connections.mysql.prefix");
        $sql="DELETE FROM {$tbPre}cache";
        Db()->execute($sql);
        @rename(LTCMS_CACHE.'/php/', LTCMS_CACHE.'/'.date('YmdHis',LTCMS_TIME).'.tmp/');
    }

    /**
     *  删除过期缓存
     */
    public function expire()
    {
        $tbPre=config("database.connections.mysql.prefix");
        $sql="SELECT cacheid FROM {$tbPre}cache WHERE expireTime <".LTCMS_TIME." ORDER BY expireTime ASC LIMIT 100";
        $result=Db()->query($sql);
        foreach($result as $val){
            $cid = $val['cacheid'];
            $this->rm($cid);
            Db()->execute("DELETE FROM {$tbPre}cache WHERE cacheid='{$cid}'");
        }
    }
}