<?php

namespace app\utils\db;

use ltcms\db\connector\Mysql;
use ltcms\db\BaseQuery;

class Custom_connection extends Mysql
{
    /**
     * 搜索兼容
     * @param BaseQuery $query
     * @return array|int
     */
    public function select($query)
    {
        if(is_string($query)){
            return $this->execute($query);
        }else{
            return parent::select($query);
        }
    }

    /**
     * 设置表名
     */
    public function name($name){
        return $this->table($name);
    }

    /**
     * 设置表名
     */
    public function tb_name($name){
        return parent::name($name);
    }

    /**
     * 事务回滚
     */
    public function rollbackTrans(){
        $this->rollback();
        return $this;
    }

    /**
     * 事务提交
     */
    public function commitTrans(){
        $this->commit();
        return $this;
    }

    /**
     * 更新数据
     * @param BaseQuery $query
     */
    public function update(BaseQuery $query){
        $rowCount=parent::update($query);
        $return=array();
        $return["affected_rows"]=$rowCount;
        return $return;
    }

    /**
     * 添加数据
     * @param BaseQuery $query
     */
    public function insert(BaseQuery $query,$getLastInsID = false){
        $options = $query->parseOptions();
        $sequence  = $options['sequence'] ?? null;
        $affected_rows=parent::insert($query);
        $lastInsId=$this->getLastInsID($query,$sequence);
        $return=array();
        $return["insert_id"]=$lastInsId;
        $return["affected_rows"]=$affected_rows;
        return $return;
    }

    /**
     * 获取数据
     */
    public function fetch($result)
    {
        return $result;
    }

    /**
     * 获取数据
     */
    public function query($sql, array $bind = [], $master = false)
    {
        return $this->execute($sql,$bind);
    }

    /**
     * 执行语句
     */
    public function execute($sql, array $bind = [])
    {
        $sql=trim($sql);
        if(strtolower(substr($sql, 0, 6))=="select" || in_array(strtolower(substr($sql, 0, 4)),array("show","desc"))){
            $this->pdoExecute($this->newQuery(), $sql, $bind, true);
            $resultSet    = $this->getResult(false);
            return $resultSet;
        }else{
            $affected_rows=$this->pdoExecute($this->newQuery(), $sql, $bind, true);
            $execute_result=$this->getExecuteResult();
            if($execute_result===true){
                if(in_array(strtolower(substr($sql, 0, 6)),array("insert","update","delete")) || in_array(strtolower(substr($sql, 0, 7)),array("replace"))){
                    return $affected_rows;
                }
            }
            return $execute_result;
        }
    }

    /**
     * 删除数据
     */
    public function delete(BaseQuery $query){
        $affected_rows=parent::delete($query);
        $return=array();
        $return["affected_rows"]=$affected_rows;
        return $return;
    }

    /**
     * 删除数据
     */
    public function insertAll(BaseQuery $query, array $dataSet = [], $limit = 0){
        $affected_rows=parent::insertAll($query,$dataSet,$limit);
        $return=array();
        $return["affected_rows"]=$affected_rows;
        return $return;
    }
}