<?php

namespace app\utils\base\plugin;

class P_page
{
    /**
     * 第一页
     * @var
     */
    public $firstPage;

    /**
     * 最后一页
     * @var
     */
    public $lastPage;

    /**
     * 页数长度
     * @var
     */
    public $pageLength=10;

    /**
     * 获取分页样式
     * @return string
     */
    public function getPageBar($data)
    {
        $url = request()->url();
        $url = preg_replace('/page=\d?&/','',$url);
        $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
        $mark = '=';
        if(strpos($url,'?') !== false){
            $index = '&page';
        }else{
            $index = '?page';
        }
        $baseUrl = "{$url}{$index}{$mark}";

        $href = $baseUrl."1";
        $tem='<span><a href="'.$href.'">'.lang("page.home").'</a></span>';

        $href = $baseUrl.($data["page"]-1);
        if($data["firstPage"]>1){
            $tem.='<span><a href="'.$href.'">'.lang("page.leftBtn").'</a></span>';
        }

        $tem.='<ul>';
        for($i=$data["firstPage"];$i<=$data["lastPage"];$i++){
            $href = $baseUrl.$i;
            if($i==$data["page"]){
                $tem.='<li class="active" ><a href="'.$href.'">'.$i.'</a></li>';
            }else{
                $tem.='<li><a href="'.$href.'">'.$i.'</a></li>';
            }
        }
        $tem.='</ul>';

        $href = $baseUrl.($data["page"]+1);
        if($data["lastPage"] < $data["totalPage"]){
            $tem.='<span><a href="'.$href.'">'.lang("page.rightBtn").'</a></span>';
        }

        $href = $baseUrl.$data["totalPage"];
        $tem.='<span><a href="'.$href.'">'.lang("page.end").'</a></span>';
        return $tem;
    }

    /**
     * 初始化页数值
     */
    public  function getRange($currentPage,$totalPage){
        $this->firstPage=$currentPage-floor($this->pageLength/2);
        if($this->firstPage<=0)
        {
            $this->firstPage=1;
        }

        $this->lastPage=$this->firstPage + $this->pageLength-1;
        if($this->lastPage > $totalPage)
        {
            $this->lastPage=$totalPage;
            $this->firstPage=($totalPage-$this->pageLength) >0?$totalPage-$this->pageLength+1:1;
        }
    }

    /**
     * 获取分页样式
     * @return string
     */
    public function getPageBarV2($data)
    {
        $this->getRange($data["page"],$data["totalPage"]);
        $url = request()->url();
        $url = preg_replace('/page=\d?&/','',$url);
        $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
        $mark = '=';
        if(strpos($url,'?') !== false){
            $index = '&page';
        }else{
            $index = '?page';
        }
        $baseUrl = "{$url}{$index}{$mark}";

        $href = $baseUrl."1";
        $tem='<a href="'.$href.'"><span>'.lang("page.home").'</span></a>';

        $href = $baseUrl.($data["page"]-1);
        if($this->firstPage>1){
            $tem.='<a href="'.$href.'"><span class="prev" >'.lang("page.pre").'</span></a>';
        }

        $tem.='<ul>';
        for($i=$this->firstPage;$i<=$this->lastPage;$i++){
            $href = $baseUrl.$i;
            if($i==$data["page"]){
                $tem.='<li><a class="page_active"  href="'.$href.'"><span>'.$i.'</span></a></li>';
            }else{
                $tem.='<li><a href="'.$href.'"><span>'.$i.'</span></a></li>';
            }
        }
        $tem.='</ul>';

        $href = $baseUrl.($data["page"]+1);
        if($this->lastPage < $data["totalPage"]){
            $tem.='<a href="'.$href.'"><span>'.lang("page.next").'</span></a>';
        }

        $href = $baseUrl.$data["totalPage"];
        $tem.='<a href="'.$href.'"><span>'.lang("page.end").'</span></a>';

        $tem.="<b style='font-size: 14px;color: #606266;'>共{$data["totalPage"]}页/{$data["total"]}条</b>";
        return $tem;
    }
}