<?php

namespace app\service\index;

use app\db\index\D_article;

class S_article
{
    public $d_article;

    public function __construct()
    {
        $this->d_article = new D_article();
    }

    /**
     * 文档数据
     * @param string $paramObj
     * @return array
     */
    public function docData($paramObj=""){
        return $this->d_article->docData($paramObj);
    }

    /**
     * 取文章信息
     * @param string $paramObj
     * @return array
     */
    public function info($paramObj=""){
        return $this->d_article->info($paramObj);
    }

    /**
     * 获取相关文章列表
     * @param string $paramObj
     * @return array
     */
    public function getCorrelationList($paramObj=""){
        return $this->d_article->getCorrelationList($paramObj);
    }

    /**
     * 获取首页中间下边文章列表
     * @param string $paramObj
     * @return array
     */
    public function getList($paramObj=""){
        return $this->d_article->getList($paramObj);
    }

    /**
     * 获取文件推荐信息
     * @param string $paramObj
     * @return array
     */
    public function getRecommend($paramObj=""){
        return $this->d_article->getRecommend($paramObj);
    }

    /**
     * 随机数据
     * @param string $paramObj
     * @return array
     */
    public function articleData($paramObj=""){
        return $this->d_article->articleData($paramObj);
    }

    /**
     * 标签数据
     * @param string $paramObj
     * @return array
     */
    public function tagData($paramObj=""){
        return $this->d_article->tagData($paramObj);
    }

    /**
     * 随机数据
     * @param string $paramObj
     * @return array
     */
    public function randData($paramObj=""){
        return $this->d_article->randData($paramObj);
    }

    /**
     * 上一篇
     * @param string $paramObj
     * @return array
     */
    public function pre($paramObj=""){
        return $this->d_article->pre($paramObj);
    }

    /**
     * 下一篇
     * @param string $paramObj
     * @return array
     */
    public function next($paramObj=""){
        return $this->d_article->next($paramObj);
    }

    /**
     * 获取热门文章列表 /就是特定时间内浏览量最多的
     * @param string $paramObj
     * @return array
     */
    public function getHighClickList($paramObj=""){
        return $this->d_article->getHighClickList($paramObj);
    }
    /**
     * 上报点击量+1
     * @param string $paramObj
     * @return array
     */
    public function uploadClickLogs($paramObj=""){
        return $this->d_article->uploadClickLogs($paramObj);
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
    /**
     * 取同模型id,多个文章id信息
     * @param string $paramObj
     * @return array
     */
    public function infos($paramObj=""){
        return $this->d_article->infos($paramObj);
    }
}