<?php

namespace app\logic\admin;

class L_setting
{
    /**
     * 记录数据[批量]
     * @param string $paramObj
     */
    public function recordBatch($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'setting' => '',
                'config' => '',
                'pid' => 'require',
            );
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->setting){
                if ($final_arr["error_no"] == 0) {
                    Db()->startTrans();
                    $dataObj->data->use_trans = true;
                }
                if($final_arr["error_no"]==0) {
                    //先删除
                    $paramsObj = paramsObj();
                    $paramsObj->params = array(
                        "pid" => $dataObj->request->pid,
                    );
                    $checkResult = app("S_Admin_setting")->deleteByPid($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if($final_arr["error_no"]==0){
                    $data=array();
                    foreach($dataObj->request->setting as $key=>$val){
                        $tmp=array();
                        $tmp["pid"]=$dataObj->request->pid;
                        $tmp["itemKey"]=$key;
                        $tmp["itemValue"]=is_array($val)?implode(",",$val):$val;
                        $data[]=$tmp;
                    }
                    $paramsObj = paramsObj();
                    $paramsObj->params = array(
                        "data" => $data,
                    );
                    $checkResult = app("S_Admin_setting")->storeBatch($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($dataObj->data->use_trans) {
                    if ($final_arr["error_no"] == 0) {
                        Db()->commitTrans();
                    } else {
                        Db()->rollbackTrans();
                    }
                }
                if($final_arr["error_no"]==0){
                    //更新缓存数据
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "pid"=>$dataObj->request->pid,
                    );
                    $checkResult=app("L_Common_caches")->updateSetting($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            $backend_name=isset($dataObj->request->setting["backend_name"])?$dataObj->request->setting["backend_name"]:"";
            if($backend_name){
                if(!isset($dataObj->request->config)){
                    $dataObj->request->config=array();
                }
                $dataObj->request->config["app.app_map"]=array(
                    $backend_name=>"admin"
                );
            }
            upPhpConfig($dataObj->request->config); //更新配置文件
            if($dataObj->request->config && is_array($dataObj->request->config)){
                $url=config("app.url","");
                $newUrl=getVal($dataObj->request->config,"app.url","");
                if($newUrl && $url && $newUrl!=$url){
                    $paramsObj=paramsObj();
                    $paramsObj->mixed=0;
                    $paramsObj->params=array(
                        'old_url' => $url,
                        'new_url' => $newUrl,
                    );
                    app("C_tool")->replaceSiteUrl($paramsObj);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => 'require',
                'itemValue' => '',
                'pid' => 'require',
            );
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'itemKey' => $dataObj->request->itemKey,
                'itemValue' => $dataObj->request->itemValue,
                'pid' => $dataObj->request->pid,
            );
            $checkResult = app("S_Admin_setting")->store($paramsObj);
            if ($checkResult["error_no"] == 0) {

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            //更新缓存数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "pid"=>$dataObj->request->pid,
            );
            $checkResult=app("L_Common_caches")->updateSetting($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 安装初始化设置
     * @param string $paramObj
     */
    public function installInit($paramObj=""){
        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $installSetting=config("setting.install",array());
            if($installSetting){
                foreach($installSetting as $pid=>$setData){
                    foreach($setData as $setKey=>$setVal){
                        if($final_arr["error_no"]==0){
                            $paramsObj = paramsObj();
                            $paramsObj->params = array(
                                "itemKey"=>$setKey,
                                "itemValue"=>$setVal,
                                "pid"=>$pid,
                            );
                            $checkResult = app("S_Admin_setting")->record($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]){
                            break;
                        }
                    }
                }
            }
        }
        return $final_arr;
    }
}