<?php

/**
 *      "catdir"=>"<catdir|[a-zA-Z0-9_]+>",
"page"=>"<page|[0-9]+>",
"itemid"=>"<articleId|[0-9]+>",
"mix_itemid"=>"<mix_articleId|[a-zA-Z0-9]+>",
"catid"=>"<catId|[0-9]+>",
"year"=>"<year|[0-9]{4}>",
"month"=>"<month|[0-9]{2}>",
"day"=>"<day|[0-9]{2}>",
 */

router()->group(function () {
    $moduleData=module("all");
    if($moduleData){
        $pattern=array(
            "catdir"=>"[a-zA-Z0-9_]+",
            "page"=>"[0-9]+",
            "articleId"=>"[0-9]+",
            "mix_articleId"=>"[a-zA-Z0-9]+",
            "catId"=>"[0-9]+",
            "year"=>"[0-9]{4}",
            "month"=>"[0-9]{2}",
            "day"=>"[0-9]{2}",
        );
        $replace=array(
            "catdir"=>"<catdir>",
            "page"=>"<page>",
            "itemid"=>"<articleId>",
            "mix_itemid"=>"<mix_articleId>",
            "catid"=>"<catId>",
            "year"=>"<year>",
            "month"=>"<month>",
            "day"=>"<day>",
        );
        foreach($moduleData as $mval){
            if($mval["module"]=="article" && $mval["isLink"]=="0"){
                router()->get($mval["urlPath"], "Article/index")->append(array("moduleId"=>$mval["id"]));

                $moduleListUrlRule=getModuleListUrlRule($mval["id"],$replace);
                $moduleItemUrlRule=getModuleItemUrlRule($mval["id"],$replace);

                $listRule=$moduleListUrlRule["rule"]; //列表路由
                $listRulePage=$moduleListUrlRule["rulePage"]; //列表分页路由
                $conRule=$moduleItemUrlRule["rule"]; //内容路由

                if(($index=strpos($listRule,"?")) !==false){
                    $listRule=substr($listRule,0,$index);
                }
                if(($index=strpos($listRulePage,"?")) !==false){
                    $listRulePage=substr($listRulePage,0,$index);
                }
                if(($index=strpos($conRule,"?")) !==false){
                    $conRule=substr($conRule,0,$index);
                }
                router()->get($mval["urlPath"]."/".rtrim($listRule,"/"), "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($listRulePage,"/"), "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($conRule,"/"), "Article/detail")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);

                router()->get($mval["urlPath"]."/".rtrim($listRule,"/")."/", "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($listRulePage,"/")."/", "Article/lists")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
                router()->get($mval["urlPath"]."/".rtrim($conRule,"/")."/", "Article/detail")->append(array("moduleId"=>$mval["id"]))->pattern($pattern);
            }
        }
    }
}, ["webStatus","globalConfig","securityCsp","securityXss"]);

