<?php

namespace app\db\api;

class D_category
{
    /**
     * 获取数据
     * @param string $paramObj
     */
    public function getData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'moduleType' => '',
                'pid' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["moduleType"] = "module";
            $dataDefault["pid"] = 0;
            $dataDefault["field"] = "id,name,catDir,seo_title,seo_keywords,seo_description,linkurl,style,level";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->moduleType
            );
            $condition[] = array(
                "dataId", "=", $dataObj->request->moduleId
            );
            $condition[] = array(
                "disabled", "=", "1"
            );
            if(is_numeric($dataObj->request->pid)){
                $condition[] = array(
                    "pid", "=", $dataObj->request->pid
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->order("sort", "asc")->order("id", "desc")->where($condition)->select();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }
}