<?php

namespace app\db\admin;

use \app\db\D_module as D_module_base;

use app\model\M_module;
use ltcms\db\Db_raw;

class D_module extends  D_module_base
{
    /**
     * 所有数据
     * @param string $paramObj
     */
    public function allData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => '',
                'isLink' => '',
                'format' => '',
                'field' => '',
                'module' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            if($dataObj->request->id){
                $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
                $condition[] = array(
                    "id", "in", $ids
                );
            }
            if(is_numeric($dataObj->request->isLink)){
                $condition[] = array(
                    "isLink", "=", $dataObj->request->isLink
                );
            }
            if($dataObj->request->module){
                $condition[] = array(
                    "module", "=", $dataObj->request->module
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::module())->field($dataObj->request->field)->where($condition)->select();
                $return=array();
                if($result){
                    foreach($result as  $key=>$val){
                        $return[$val["id"]]=$dataObj->request->format?$this->detailed($val,$dataObj->request->format):$val;
                    }
                }
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'isMenu' => '',
                'module' => '',
                'name' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if ($dataObj->request->module) {
                $condition[] = array(
                    "module", "=", $dataObj->request->module
                );
            }
            if (is_numeric($dataObj->request->isMenu)) {
                $condition[] = array(
                    "isMenu", "=", $dataObj->request->isMenu
                );
            }
            if ($dataObj->request->name) {
                $raw=new Db_raw();
                $raw->setContent("LOCATE('{$dataObj->request->name}',`name`)");
                $condition[] = array(
                    $raw, ">", 0
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::module())->field($dataObj->request->field)->order("id", "desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::module())->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    if($result && $dataObj->request->format){
                        $result=$this->detailed($result, $dataObj->request->format);
                    }
                    $final_arr["result"] =$result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情 by name
     * @param string $paramObj
     */
    public function infoByName($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => '',
                'name' => 'require',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if($dataObj->request->id){
                $condition[] = array(
                    "id", "!=", $dataObj->request->id
                );
            }
            $condition[] = array(
                "name", "=", $dataObj->request->name
            );
            try {
                $result = Db()->name(app("cmsTable")::module())->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    if($result && $dataObj->request->format){
                        $result=$this->detailed($result, $dataObj->request->format);
                    }
                    $final_arr["result"] =$result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情 by plugins
     * @param string $paramObj
     */
    public function infoByPlugins($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => '',
                'plugins' => 'require',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if($dataObj->request->id){
                $condition[] = array(
                    "id", "!=", $dataObj->request->id
                );
            }
            $condition[] = array(
                "plugins", "=", $dataObj->request->plugins
            );
            try {
                $result = Db()->name(app("cmsTable")::module())->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    if($result && $dataObj->request->format){
                        $result=$this->detailed($result, $dataObj->request->format);
                    }
                    $final_arr["result"] =$result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取最大数量
     * @param string $paramObj
     */
    public function getMaxCount($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            try {
                $result = Db()->name(app("cmsTable")::module())->field("count(*) as nums")->find();
                $final_arr["result"] =$result["nums"]?$result["nums"]:0;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'isLink' => 'require|number',
                'name' => 'require',
                'module' => 'requireIf:isLink,0',
                'urlPath' => 'requireIf:isLink,0',
                'domain_pc' => '',
                'domain_mobile' => '',
                'style' => '',
                'plugins' => '',
                'isMenu' => 'require|number',
                'isBlank' => 'require|number',
                'disabled' => 'number',
                'linkUrl' => 'requireIf:isLink,1',
            );
            $dataDefault = array();
            $dataDefault["disabled"]=1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_module::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                if (isset($data["isLink"]) && $data["isLink"]=="0") {
                    $data["linkUrl"] = rtrim(config("app.url"),"/")."/".$dataObj->request->urlPath."/";
                }
                if(!(isset($data["plugins"]) && $data["plugins"])){
                    $data["plugins"]=impulseSender();
                }
                $data["createTime"] = app("ltcmsTime")::getTime();
                $data["installTime"] = $data["createTime"];
                $data["updateTime"] = $data["createTime"];
                $result = Db()->name(app("cmsTable")::module())->data($data)->insert();
                if($result["insert_id"] >0){
                    if ($final_arr["error_no"] == 0) {
                        $return = array();
                        $return["id"] = $result["insert_id"];
                        $return["affected_rows"] = $result["affected_rows"];
                        $dataObj->data->insertData=$return;
                    }
                    if ($final_arr["error_no"] == 0) {
                        //更新排序
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$result["insert_id"],
                        );
                        $checkResult=$this->updateSort($paramsObj);
                        if ($checkResult["error_no"] == 0) {

                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->module=="article"){
                if ($final_arr["error_no"] == 0) {
                    //创建表
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$dataObj->data->insertData["id"],
                    );
                    $checkResult=$this->createTable($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $final_arr["result"] = $dataObj->data->insertData;
            $final_arr["extra"] = array(
                "module"=>$dataObj->request->module,
                "name"=>$dataObj->request->name,
            );
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'isLink' => 'require|number',
                'name' => 'require',
                'module' => 'requireIf:isLink,0',
                'urlPath' => 'requireIf:isLink,0',
                'domain_pc' => '',
                'domain_mobile' => '',
                'plugins' => 'require',
                'style' => '',
                'isMenu' => 'require|number',
                'isBlank' => 'require|number',
                'disabled' => 'number',
                'linkUrl' => 'requireIf:isLink,1',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "plugins"=>$dataObj->request->plugins,
            );
            $checkResult=$this->infoByPlugins($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if(!$result){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "name"=>$dataObj->request->name,
                        "isLink"=>$dataObj->request->isLink,
                        "module"=>$dataObj->request->module,
                        "urlPath"=>$dataObj->request->urlPath,
                        "domain_pc"=>$dataObj->request->domain_pc,
                        "domain_mobile"=>$dataObj->request->domain_mobile,
                        "style"=>$dataObj->request->style,
                        "isMenu"=>$dataObj->request->isMenu,
                        "isBlank"=>$dataObj->request->isBlank,
                        "disabled"=>$dataObj->request->disabled,
                        "linkUrl"=>$dataObj->request->linkUrl,
                        "plugins"=>$dataObj->request->plugins,
                    );
                    $checkResult=$this->store($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $return=array();
                        $return["id"]=$checkResult["result"]["id"];
                        $return["exist"]=0;
                        $final_arr["result"]=$return;
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $return=array();
                    $return["id"]=$result["id"];
                    $return["exist"]=1;
                    $final_arr["result"]=$return;
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 创建表
     * @param string $paramObj
     */
    public function createTable($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $id=$dataObj->request->id;
            $connect=config("database.connect");
            $db_table_pre=config("database.{$connect}.tb_pre");

            $sql=array();
            $sql[]="SET NAMES utf8mb4";
            $sql[]="SET FOREIGN_KEY_CHECKS = 0";
            $sql[]="CREATE TABLE IF NOT EXISTS `{table_pre}article_{$id}`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `moduleId` int(11) NOT NULL DEFAULT '0' COMMENT '模块id',
  `userId` int(11) NOT NULL,
  `isAdmin` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否为管理员 1=管理员表, ',
  `webTitle` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '网站标签页标题',
  `webKeyWords` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '标签页KeyWords',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文章标题',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文章缩略图url',
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述  ',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '文章状态  1 草稿, 2待审核, ,3已发布',
  `author` char(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '作者',
  `addTime` int(11) NOT NULL DEFAULT '0' COMMENT '发布时间戳',
  `updateTime` int(11) NOT NULL DEFAULT '0' COMMENT '最后修改时间戳',
  `attribute` tinyint(4) NOT NULL DEFAULT '0' COMMENT '文章属性：1 推荐',
  `hits` int(11) NOT NULL DEFAULT '0' COMMENT '点击计数',
  `recycle` tinyint(4) NOT NULL DEFAULT '1' COMMENT ' 1正常  2回收站',
  `level` tinyint(4) NOT NULL DEFAULT '1' COMMENT '文章等级',
  `categoryId` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `linkUrl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '链接地址',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `userId` (`userId`) USING BTREE,
  KEY `author` (`author`) USING BTREE,
  KEY `status_recycle_categoryId` (`status`,`recycle`,`categoryId`) USING BTREE,
  KEY `categoryId` (`categoryId`) USING BTREE,
  KEY `title` (`title`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;
";
            $sql[]="CREATE TABLE IF NOT EXISTS `{table_pre}article_data_{$id}`  (
  `id` int NOT NULL DEFAULT 0 COMMENT '和文章列表数据id相同',
  `articleContent` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '超大字段,再具体文章内容',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '文章具体内容' ROW_FORMAT = Dynamic";
            $sql[]="SET FOREIGN_KEY_CHECKS = 1";
            if($sql){
                foreach($sql as $val){
                    $sql=str_replace("{table_pre}",$db_table_pre,$val);
                    $ok=Db()->query($sql);
                    if(!$ok){
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新排序
     * @param string $paramObj
     */
    public function updateSort($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $checkResult = $this->getMaxCount();
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->maxCount=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $data = array();
            $data["sort"] = $dataObj->data->maxCount;
            try {
                Db()->name(app("cmsTable")::module())->where($condition)->data($data)->update();
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'name' => 'require',
                'urlPath' => 'requireIf:isLink,0',
                'domain_pc' => '',
                'domain_mobile' => '',
                'style' => '',
                'logo' => 'require|number',
                'isMenu' => 'require|number',
                'isBlank' => 'require|number',
                'disabled' => 'number',
                'linkUrl' => 'requireIf:isLink,1',
                'sort' => '',
                'isLink' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "verify" => 1,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->infoData=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->data->infoData["id"]
            );
            $fields=M_module::getFields();
            $mergeData=app("ltcmsFormat")->modelDataMerge($dataObj->data->infoData,objToArray($dataObj->request));
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request,$mergeData);
            if ($mergeData["isLink"]=="0") {
                $data["linkUrl"] = rtrim(config("app.url"),"/")."/".$data["urlPath"]."/";
            }
            if ($data) {
                $data["updateTime"] = app("ltcmsTime")::getTime();
                try {
                    $result = Db()->name(app("cmsTable")::module())->where($condition)->data($data)->update();
                    $return = array();
                    $return["id"] = $dataObj->request->id;
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::module())->where($condition)->delete();
                $return = array();
                $return["id"] = $ids;
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}